/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.gson;

import com.google.gson.JsonParseException;
import com.softwarementors.extjs.djn.DirectJNgineException;
import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredStandardMethod;
import com.softwarementors.extjs.djn.router.processor.ResponseData;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonException
extends DirectJNgineException {
    private static final long serialVersionUID = 4992911540391211769L;

    private JsonException(String message, Throwable cause) {
        super(message, cause);
        assert (!StringUtils.isEmpty(message));
        assert (cause != null);
    }

    public static JsonException forFailedConversionFromResponseToJson(ResponseData response, Throwable ex) {
        assert (response != null);
        assert (ex != null);
        return new JsonException("Failed attempt to convert a response to json. " + response.getFullLogDescription(), ex);
    }

    public static JsonException forFailedConversionFromJsonStringToMethodParameters(RegisteredStandardMethod method, String jsonParametersString, Class<?>[] parameterTypes, Type[] gsonParameterTypes, JsonParseException ex) {
        assert (method != null);
        assert (jsonParametersString != null);
        assert (parameterTypes != null);
        assert (ex != null);
        StringBuilder typeNames = JsonException.getCommaSeparatedTypeNames(parameterTypes, gsonParameterTypes);
        return new JsonException("Failed attempt to convert from a json string to java method parameters. Method='" + method.getFullName() + "', Json string='" + jsonParametersString + "', ExpectedTypes='" + typeNames + "'", (Throwable)ex);
    }

    private static StringBuilder getCommaSeparatedTypeNames(Class<?>[] parameterTypes, Type[] gsonParameterTypes) {
        StringBuilder typeNames = new StringBuilder();
        boolean hasGsonParametersTypes = gsonParameterTypes != null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            boolean atEnd;
            Class<?> type = parameterTypes[i];
            typeNames.append(type.getName());
            if (hasGsonParametersTypes) {
                assert (gsonParameterTypes != null);
                Type gsonType = gsonParameterTypes[i];
                if (gsonType != null) {
                    typeNames.append(" ::GENERIC= ");
                    typeNames.append(gsonType.toString());
                    typeNames.append(":: ");
                }
            }
            boolean bl = atEnd = i == parameterTypes.length - 1;
            if (atEnd) continue;
            typeNames.append(", ");
        }
        return typeNames;
    }
}

