/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.gson.GsonBuilderConfigurator;
import java.lang.reflect.Type;
import java.util.Date;

public class DefaultGsonBuilderConfigurator
implements GsonBuilderConfigurator {
    public void configure(GsonBuilder builder, GlobalConfiguration configuration) {
        assert (builder != null);
        assert (configuration != null);
        if (configuration.getDebug()) {
            builder.setPrettyPrinting();
        }
        builder.serializeNulls();
        builder.disableHtmlEscaping();
        builder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        builder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateSerializer
    implements JsonSerializer<Date> {
        private DateSerializer() {
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            assert (src != null);
            assert (context != null);
            assert (typeOfSrc != null);
            JsonPrimitive result = new JsonPrimitive((Number)src.getTime());
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            assert (json != null);
            assert (context != null);
            assert (typeOfT != null);
            if (!json.isJsonPrimitive()) {
                throw new JsonParseException("The value for a Date must be a valid number");
            }
            assert (json instanceof JsonPrimitive);
            JsonPrimitive primitivejson = (JsonPrimitive)json;
            if (!primitivejson.isNumber()) {
                throw new JsonParseException("The value for a Date must be a valid number");
            }
            return new Date(primitivejson.getAsLong());
        }
    }
}

