/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.api;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredAction;
import com.softwarementors.extjs.djn.api.RegisteredApi;
import com.softwarementors.extjs.djn.api.RegisteredPollMethod;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    @NonNull
    static final Logger logger = Logger.getLogger(Registry.class);
    @NonNull
    private Map<String, RegisteredApi> apisByName = new HashMap<String, RegisteredApi>();
    @NonNull
    private Map<String, RegisteredAction> actionsByName = new HashMap<String, RegisteredAction>();
    @NonNull
    private Map<String, RegisteredPollMethod> pollMethodsByName = new HashMap<String, RegisteredPollMethod>();
    @NonNull
    private Map<String, String> sources = new HashMap<String, String>();
    @NonNull
    private GlobalConfiguration globalConfiguration;
    @NonNull
    private static final Map<Method, Type[]> gsonGenericParameterTypes = new HashMap<Method, Type[]>();

    public static void registerParameterType(Method method, int parameter, Type type) {
        assert (method != null);
        assert (parameter < method.getParameterTypes().length);
        assert (type != null);
        Type[] methodParameterizedTypes = gsonGenericParameterTypes.get(method);
        if (methodParameterizedTypes == null) {
            methodParameterizedTypes = new Type[method.getParameterTypes().length];
            gsonGenericParameterTypes.put(method, methodParameterizedTypes);
        }
        methodParameterizedTypes[parameter] = type;
    }

    public static Type[] getParameterTypes(Method m) {
        Type[] result = gsonGenericParameterTypes.get(m);
        return result;
    }

    public Registry(GlobalConfiguration globalConfiguration) {
        assert (globalConfiguration != null);
        this.globalConfiguration = globalConfiguration;
    }

    public RegisteredApi addApi(String name, String apiFileName, String fullApiFileName, String apiNamespace, String actionsNamespace) {
        assert (!StringUtils.isEmpty(name));
        assert (!StringUtils.isEmpty(apiNamespace));
        assert (!StringUtils.isEmpty(apiFileName));
        assert (!StringUtils.isEmpty(fullApiFileName));
        assert (actionsNamespace != null);
        assert (!this.hasApi(name));
        RegisteredApi result = new RegisteredApi(this, name, apiFileName, fullApiFileName, apiNamespace, actionsNamespace);
        this.apisByName.put(name, result);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered new Api: " + name));
        }
        return result;
    }

    public boolean hasSource(String sourceName) {
        assert (!StringUtils.isEmpty(sourceName));
        return this.sources.containsKey(sourceName);
    }

    public void addSource(String sourceName, String code) {
        assert (!StringUtils.isEmpty(sourceName));
        assert (code != null);
        assert (!this.hasSource(sourceName));
        this.sources.put(sourceName, code);
    }

    public String getSource(String sourceName) {
        assert (!StringUtils.isEmpty(sourceName));
        return this.sources.get(sourceName);
    }

    public RegisteredApi getApi(String api) {
        assert (!StringUtils.isEmpty(api));
        assert (this.hasApi(api));
        return this.apisByName.get(api);
    }

    public boolean hasApi(String name) {
        assert (!StringUtils.isEmpty(name));
        return this.apisByName.containsKey(name);
    }

    public List<RegisteredApi> getApis() {
        ArrayList<RegisteredApi> result = new ArrayList<RegisteredApi>(this.apisByName.values());
        return result;
    }

    public RegisteredAction getAction(String name) {
        assert (!StringUtils.isEmpty(name));
        assert (this.hasAction(name));
        return this.actionsByName.get(name);
    }

    public boolean hasAction(String name) {
        assert (!StringUtils.isEmpty(name));
        return this.actionsByName.containsKey(name);
    }

    public List<RegisteredAction> getActions() {
        ArrayList<RegisteredAction> result = new ArrayList<RegisteredAction>(this.actionsByName.values());
        return result;
    }

    public boolean hasPollMethod(String eventName) {
        assert (!StringUtils.isEmpty(eventName));
        return this.pollMethodsByName.containsKey(eventName);
    }

    @CheckForNull
    public RegisteredPollMethod getPollMethod(String eventName) {
        assert (!StringUtils.isEmpty(eventName));
        assert (this.hasPollMethod(eventName));
        return this.pollMethodsByName.get(eventName);
    }

    public List<RegisteredPollMethod> getPollMethods() {
        ArrayList<RegisteredPollMethod> result = new ArrayList<RegisteredPollMethod>(this.pollMethodsByName.values());
        return result;
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    void registerPollMethod(RegisteredPollMethod result) {
        assert (result != null);
        assert (!this.pollMethodsByName.containsKey(result.getName()));
        this.pollMethodsByName.put(result.getName(), result);
    }

    void registerAction(RegisteredAction result) {
        assert (result != null);
        assert (!this.actionsByName.containsKey(result.getName()));
        this.actionsByName.put(result.getName(), result);
    }
}

