/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.api;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredApi;
import com.softwarementors.extjs.djn.api.RegisteredPollMethod;
import com.softwarementors.extjs.djn.api.RegisteredStandardMethod;
import com.softwarementors.extjs.djn.api.Registry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredAction {
    @NonNull
    private Map<String, RegisteredPollMethod> pollMethods = new HashMap<String, RegisteredPollMethod>();
    @NonNull
    private Class<?> actionClass;
    @NonNull
    private String name;
    @NonNull
    private Map<String, RegisteredStandardMethod> standardMethodsByName = new HashMap<String, RegisteredStandardMethod>();
    @NonNull
    private RegisteredApi api;
    public static final String NAME_PROPERTY = "name";

    RegisteredAction(RegisteredApi api, Class<?> actionClass, String name) {
        assert (api != null);
        assert (actionClass != null);
        assert (!StringUtils.isEmpty(name));
        this.actionClass = actionClass;
        this.name = name;
        this.api = api;
    }

    public RegisteredApi getApi() {
        return this.api;
    }

    public Registry getRegistry() {
        return this.getApi().getRegistry();
    }

    public RegisteredPollMethod addPollMethod(String name, Method method) {
        assert (!StringUtils.isEmpty(name));
        assert (method != null);
        assert (RegisteredPollMethod.isValidPollMethod(method));
        assert (!this.getRegistry().hasPollMethod(name));
        RegisteredPollMethod result = new RegisteredPollMethod(this, name, method);
        this.pollMethods.put(name, result);
        this.getRegistry().registerPollMethod(result);
        if (Registry.logger.isDebugEnabled()) {
            Registry.logger.debug((Object)("  - Registered new Poll Method. Name: '" + name + "', Java method: '" + result.getActionClass() + "." + result.getMethod().getName() + "'"));
        }
        return result;
    }

    public RegisteredPollMethod getPollMethod(String eventName) {
        assert (!StringUtils.isEmpty(eventName));
        return this.pollMethods.get(eventName);
    }

    public List<RegisteredPollMethod> getPollMethods() {
        return new ArrayList<RegisteredPollMethod>(this.pollMethods.values());
    }

    public RegisteredStandardMethod addStandardMethod(String name, Method method, boolean formHandler) {
        assert (!StringUtils.isEmpty(name));
        assert (method != null);
        RegisteredStandardMethod result = new RegisteredStandardMethod(this, name, method, formHandler);
        this.standardMethodsByName.put(name, result);
        if (Registry.logger.isDebugEnabled()) {
            String type = "Standard";
            if (formHandler) {
                type = "Form";
            }
            Registry.logger.debug((Object)("  - Registered new " + type + " Method. Name: '" + result.getFullName() + "'. Java method: '" + this.getActionClass().getName() + "." + method.getName() + "'"));
        }
        return result;
    }

    public RegisteredStandardMethod getStandardMethod(String methodName) {
        assert (!StringUtils.isEmpty(methodName));
        return this.standardMethodsByName.get(methodName);
    }

    public boolean hasStandardMethod(String method) {
        assert (!StringUtils.isEmpty(method));
        return this.standardMethodsByName.containsKey(method);
    }

    public List<RegisteredStandardMethod> getStandardMethods() {
        return new ArrayList<RegisteredStandardMethod>(this.standardMethodsByName.values());
    }

    public Class<?> getActionClass() {
        return this.actionClass;
    }

    public String getName() {
        return this.name;
    }

    void addStandardMethod(RegisteredStandardMethod method) {
        assert (method != null);
        assert (!this.standardMethodsByName.containsKey(method.getName()));
        this.standardMethodsByName.put(method.getName(), method);
    }

    public String getFullJavaClassName() {
        return this.getActionClass().getName();
    }
}

