/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn;

import com.softwarementors.extjs.djn.StringUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class Timer {
    @NonNull
    public static final Logger logger = Logger.getLogger(Timer.class);
    @NonNull
    private static final DecimalFormat numberFormatter = new DecimalFormat("#.##");
    private boolean running;
    private long startNanos;
    private long elapsedNanoseconds;

    public Timer() {
        this.restart();
    }

    public void restart() {
        this.running = true;
        this.elapsedNanoseconds = 0L;
        this.startNanos = System.nanoTime();
    }

    public void stop() {
        this.running = false;
        this.elapsedNanoseconds = System.nanoTime() - this.startNanos;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getElapsedMicroseconds() {
        assert (!this.isRunning());
        long result = this.elapsedNanoseconds / 1000L;
        return result;
    }

    public long getElapsedMilliseconds() {
        assert (!this.isRunning());
        return this.getElapsedMicroseconds() / 1000L;
    }

    public void stopAnLogDebugTimeInMilliseconds(String message) {
        assert (!StringUtils.isEmpty(message));
        this.stop();
        this.logDebugTimeInMilliseconds(message);
    }

    public void logDebugTimeInMilliseconds(String message) {
        assert (!StringUtils.isEmpty(message));
        assert (!this.isRunning());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(message + ": " + numberFormatter.format((double)this.getElapsedMicroseconds() / 1000.0) + " ms."));
        }
    }
}

