/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.iterator;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractIteratorMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="@")
    private String beginToken;
    @Parameter(required=true, defaultValue="@")
    private String endToken;
    @Parameter(required=true, defaultValue="item")
    private String iteratorName;
    @Parameter(property="iterator.items")
    private List<String> items;
    @Parameter
    private String content;
    @Parameter
    private File folder;
    @Parameter(defaultValue=",")
    private String delimiter;
    @Parameter(defaultValue="NAME_COMPARATOR")
    private String sortOrder;

    private List<String> getContentAsList() {
        String[] resultArray;
        ArrayList<String> result = new ArrayList<String>();
        for (String item : resultArray = this.content.split(this.delimiter)) {
            result.add(item.trim());
        }
        return result;
    }

    protected List<String> getItems() throws MojoExecutionException {
        List<Object> result = new ArrayList();
        if (this.isItemsSet()) {
            result = this.items;
        } else if (this.isContentSet()) {
            result = this.getContentAsList();
        } else if (this.isFolderSet()) {
            result = this.getFolders();
        }
        return result;
    }

    protected List<String> getFolders() {
        IOFileFilter folders = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{HiddenFileFilter.VISIBLE, DirectoryFileFilter.DIRECTORY});
        IOFileFilter makeSVNAware = FileFilterUtils.makeSVNAware((IOFileFilter)folders);
        IOFileFilter makeCVSAware = FileFilterUtils.makeCVSAware((IOFileFilter)makeSVNAware);
        String[] list = this.folder.list((FilenameFilter)makeCVSAware);
        ArrayList<File> listOfDirectories = new ArrayList<File>();
        for (String item : list) {
            listOfDirectories.add(new File(this.folder, item));
        }
        Collections.sort(listOfDirectories, this.convertSortOrder());
        ArrayList<String> resultList = new ArrayList<String>();
        for (File file : listOfDirectories) {
            resultList.add(file.getName());
        }
        return resultList;
    }

    protected String getPlaceHolder() {
        return this.getBeginToken() + this.getIteratorName() + this.getEndToken();
    }

    protected boolean isItemsNull() {
        return this.items == null;
    }

    protected boolean isItemsSet() {
        return !this.isItemsNull() && !this.items.isEmpty();
    }

    protected boolean isContentNull() {
        return this.content == null;
    }

    protected boolean isContentSet() {
        return this.content != null && this.content.trim().length() > 0;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getBeginToken() {
        return this.beginToken;
    }

    public void setBeginToken(String beginToken) {
        this.beginToken = beginToken;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public String getIteratorName() {
        return this.iteratorName;
    }

    public void setIteratorName(String iteratorName) {
        this.iteratorName = iteratorName;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public boolean isFolderSet() {
        return this.folder != null;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    public boolean isSortOrderValid(String sortOrder) {
        boolean result = sortOrder.equalsIgnoreCase("NAME_COMPARATOR") || sortOrder.equalsIgnoreCase("NAME_INSENSITIVE_COMPARATOR") || sortOrder.equalsIgnoreCase("NAME_INSENSITIVE_REVERSE") || sortOrder.equalsIgnoreCase("NAME_REVERSE") || sortOrder.equalsIgnoreCase("NAME_SYSTEM_COMPARATOR") || sortOrder.equalsIgnoreCase("NAME_SYSTEM_REVERSE");
        return result;
    }

    protected Comparator<File> convertSortOrder() {
        Comparator result = NameFileComparator.NAME_COMPARATOR;
        if (this.getSortOrder().equalsIgnoreCase("NAME_INSENSITIVE_COMPARATOR")) {
            result = NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_INSENSITIVE_REVERSE")) {
            result = NameFileComparator.NAME_INSENSITIVE_REVERSE;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_REVERSE")) {
            result = NameFileComparator.NAME_REVERSE;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_SYSTEM_COMPARATOR")) {
            result = NameFileComparator.NAME_SYSTEM_COMPARATOR;
        } else if (this.getSortOrder().equalsIgnoreCase("NAME_SYSTEM_REVERSE")) {
            result = NameFileComparator.NAME_SYSTEM_REVERSE;
        }
        return result;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }
}

