/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.maven.plugin;

import com.soebes.itf.maven.plugin.Helper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

@Mojo(name="resources-its", defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES, threadSafe=true)
public class ResourcesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter
    private String propertiesEncoding;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    private List<String> buildFilters;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter
    private String escapeString;
    @Parameter(defaultValue="false")
    private boolean includeEmptyDirs;
    @Parameter
    private List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="true")
    private boolean escapeWindowsPaths;
    @Parameter(defaultValue="@")
    private LinkedHashSet<String> delimiters;
    @Parameter(defaultValue="false")
    private boolean addDefaultExcludes;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(readonly=true)
    private List<Resource> resources;
    @Parameter(defaultValue="false")
    private boolean overwrite;
    @Parameter
    private List<String> mavenFilteringHints;
    private List<MavenResourcesFiltering> mavenFilteringComponents = new ArrayList<MavenResourcesFiltering>();
    @Parameter(defaultValue="false")
    private boolean supportMultiLineFiltering;
    @Parameter(defaultValue="false")
    private boolean fileNameFiltering;

    public void execute() throws MojoExecutionException {
        Resource resource = new Resource();
        resource.setDirectory("src/test/resources-its");
        resource.setTargetPath(this.project.getBuild().getTestOutputDirectory());
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("**/**");
        resource.setIncludes(includes);
        resource.setExcludes(Collections.emptyList());
        resource.setFiltering(true);
        this.resources = new ArrayList<Resource>();
        this.resources.add(resource);
        if (Helper.isBlank(this.encoding) && this.isFilteringEnabled(this.resources)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + System.getProperty("file.encoding") + ". Build is platform dependent!"));
            this.getLog().warn((CharSequence)"See https://maven.apache.org/general.html#encoding-warning");
        }
        try {
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(this.resources, this.outputDirectory, this.project, this.encoding, Collections.emptyList(), Collections.emptyList(), this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            mavenResourcesExecution.setInjectProjectBuildFilters(false);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setOverwrite(this.overwrite);
            mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
            mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            mavenResourcesExecution.setFilterFilenames(this.fileNameFiltering);
            mavenResourcesExecution.setAddDefaultExcludes(this.addDefaultExcludes);
            mavenResourcesExecution.setAdditionalProperties(null);
            mavenResourcesExecution.setDelimiters(this.delimiters);
            mavenResourcesExecution.setPropertiesEncoding(this.propertiesEncoding);
            List<String> filter = Arrays.asList("jpg", "jar", "war", "ear", "aar", "rar", "har", "sar", "zip", "tar", "tar.gz");
            mavenResourcesExecution.setNonFilteredFileExtensions(filter);
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private boolean isFilteringEnabled(Collection<Resource> theResources) {
        if (theResources != null) {
            return theResources.stream().anyMatch(Resource::isFiltering);
        }
        return false;
    }
}

