/*
 * Decompiled with CFR 0.152.
 */
package com.balysv.materialmenu;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import com.balysv.materialmenu.MaterialMenu;
import com.balysv.materialmenu.MaterialMenuDrawable;
import com.balysv.materialmenu.R;

public class MaterialMenuView
extends View
implements MaterialMenu {
    private MaterialMenuDrawable drawable;
    private MaterialMenuDrawable.IconState currentState = MaterialMenuDrawable.IconState.BURGER;

    public MaterialMenuView(Context context) {
        this(context, null);
    }

    public MaterialMenuView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attributeSet) {
        TypedArray attr = this.getTypedArray(context, attributeSet, R.styleable.MaterialMenuView);
        try {
            int color = attr.getColor(R.styleable.MaterialMenuView_mm_color, -1);
            boolean visible = attr.getBoolean(R.styleable.MaterialMenuView_mm_visible, true);
            int scale = attr.getInteger(R.styleable.MaterialMenuView_mm_scale, 1);
            int transformDuration = attr.getInteger(R.styleable.MaterialMenuView_mm_transformDuration, 800);
            MaterialMenuDrawable.Stroke stroke = MaterialMenuDrawable.Stroke.valueOf(attr.getInteger(R.styleable.MaterialMenuView_mm_strokeWidth, 0));
            boolean rtlEnabled = attr.getBoolean(R.styleable.MaterialMenuView_mm_rtlEnabled, false);
            this.drawable = new MaterialMenuDrawable(context, color, stroke, scale, transformDuration);
            this.drawable.setVisible(visible);
            this.drawable.setRTLEnabled(rtlEnabled);
        }
        finally {
            attr.recycle();
        }
        this.drawable.setCallback((Drawable.Callback)this);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.getPaddingLeft() != 0 || this.getPaddingTop() != 0) {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            this.drawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            this.drawable.draw(canvas);
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.adjustDrawablePadding();
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.drawable || super.verifyDrawable(who);
    }

    @Override
    public void setState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.drawable.setIconState(state);
    }

    @Override
    public MaterialMenuDrawable.IconState getState() {
        return this.drawable.getIconState();
    }

    @Override
    public void animateState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.drawable.animateIconState(state);
    }

    @Override
    public void animatePressedState(MaterialMenuDrawable.IconState state) {
        this.animateState(state);
    }

    @Override
    public void setColor(int color) {
        this.drawable.setColor(color);
    }

    @Override
    public void setVisible(boolean visible) {
        this.drawable.setVisible(visible);
    }

    @Override
    public void setTransformationDuration(int duration) {
        this.drawable.setTransformationDuration(duration);
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        this.drawable.setInterpolator(interpolator);
    }

    @Override
    public void setAnimationListener(Animator.AnimatorListener listener) {
        this.drawable.setAnimationListener(listener);
    }

    @Override
    public void setRTLEnabled(boolean rtlEnabled) {
        this.drawable.setRTLEnabled(rtlEnabled);
    }

    @Override
    public void setTransformationOffset(MaterialMenuDrawable.AnimationState animationState, float value) {
        this.currentState = this.drawable.setTransformationOffset(animationState, value);
    }

    @Override
    public MaterialMenuDrawable getDrawable() {
        return this.drawable;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int paddingX = this.getPaddingLeft() + this.getPaddingRight();
        int paddingY = this.getPaddingTop() + this.getPaddingBottom();
        if (Build.VERSION.SDK_INT >= 11) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.drawable.getIntrinsicWidth() + paddingX), (int)0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.drawable.getIntrinsicHeight() + paddingY), (int)0x40000000);
            this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.setMeasuredDimension(this.drawable.getIntrinsicWidth() + paddingX, this.drawable.getIntrinsicHeight() + paddingY);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.adjustDrawablePadding();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.state = this.currentState;
        savedState.visible = this.drawable != null && this.drawable.isDrawableVisible();
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setState(savedState.state);
        this.setVisible(savedState.visible);
    }

    private void adjustDrawablePadding() {
        if (this.drawable != null) {
            this.drawable.setBounds(0, 0, this.drawable.getIntrinsicWidth() + this.getPaddingLeft() + this.getPaddingRight(), this.drawable.getIntrinsicHeight() + this.getPaddingTop() + this.getPaddingBottom());
        }
    }

    private TypedArray getTypedArray(Context context, AttributeSet attributeSet, int[] attr) {
        return context.obtainStyledAttributes(attributeSet, attr, 0, 0);
    }

    private static class SavedState
    extends View.BaseSavedState {
        protected MaterialMenuDrawable.IconState state;
        protected boolean visible;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.state = MaterialMenuDrawable.IconState.valueOf(in.readString());
            this.visible = in.readByte() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.state.name());
            out.writeByte((byte)(this.visible ? 1 : 0));
        }
    }
}

