/*
 * Decompiled with CFR 0.152.
 */
package com.balysv.materialmenu;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class MaterialMenuDrawable
extends Drawable
implements Animatable {
    public static final int DEFAULT_COLOR = -1;
    public static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_TRANSFORM_DURATION = 800;
    public static final boolean DEFAULT_VISIBLE = true;
    private static final int BASE_DRAWABLE_WIDTH = 40;
    private static final int BASE_DRAWABLE_HEIGHT = 40;
    private static final int BASE_ICON_WIDTH = 20;
    private static final int BASE_CIRCLE_RADIUS = 18;
    private static final float ARROW_MID_LINE_ANGLE = 180.0f;
    private static final float ARROW_TOP_LINE_ANGLE = 135.0f;
    private static final float ARROW_BOT_LINE_ANGLE = 225.0f;
    private static final float X_TOP_LINE_ANGLE = 44.0f;
    private static final float X_BOT_LINE_ANGLE = -44.0f;
    private static final float X_ROTATION_ANGLE = 90.0f;
    private static final float CHECK_MIDDLE_ANGLE = 135.0f;
    private static final float CHECK_BOTTOM_ANGLE = -90.0f;
    private static final float TRANSFORMATION_START = 0.0f;
    private static final float TRANSFORMATION_MID = 1.0f;
    private static final float TRANSFORMATION_END = 2.0f;
    private static final int DEFAULT_CIRCLE_ALPHA = 200;
    private final float diph;
    private final float dip1;
    private final float dip2;
    private final float dip3;
    private final float dip4;
    private final float dip8;
    private final int width;
    private final int height;
    private final float strokeWidth;
    private final float iconWidth;
    private final float topPadding;
    private final float sidePadding;
    private final float circleRadius;
    private final Stroke stroke;
    private final Object lock = new Object();
    private final Paint iconPaint = new Paint();
    private final Paint circlePaint = new Paint();
    private float transformationValue = 0.0f;
    private boolean transformationRunning = false;
    private IconState currentIconState = IconState.BURGER;
    private AnimationState animationState = AnimationState.BURGER_ARROW;
    private IconState animatingIconState;
    private boolean visible;
    private boolean rtlEnabled;
    private ObjectAnimator transformation;
    private Animator.AnimatorListener animatorListener;
    private MaterialMenuState materialMenuState;
    private Property<MaterialMenuDrawable, Float> transformationProperty = new Property<MaterialMenuDrawable, Float>(Float.class, "transformation"){

        public Float get(MaterialMenuDrawable object) {
            return object.getTransformationValue();
        }

        public void set(MaterialMenuDrawable object, Float value) {
            object.setTransformationValue(value);
        }
    };

    public MaterialMenuDrawable(Context context, int color, Stroke stroke) {
        this(context, color, stroke, 1, 800);
    }

    public MaterialMenuDrawable(Context context, int color, Stroke stroke, int transformDuration) {
        this(context, color, stroke, 1, transformDuration);
    }

    public MaterialMenuDrawable(Context context, int color, Stroke stroke, int scale, int transformDuration) {
        Resources resources = context.getResources();
        this.dip1 = MaterialMenuDrawable.dpToPx(resources, 1.0f) * (float)scale;
        this.dip2 = MaterialMenuDrawable.dpToPx(resources, 2.0f) * (float)scale;
        this.dip3 = MaterialMenuDrawable.dpToPx(resources, 3.0f) * (float)scale;
        this.dip4 = MaterialMenuDrawable.dpToPx(resources, 4.0f) * (float)scale;
        this.dip8 = MaterialMenuDrawable.dpToPx(resources, 8.0f) * (float)scale;
        this.diph = this.dip1 / 2.0f;
        this.stroke = stroke;
        this.visible = true;
        this.width = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * (float)scale);
        this.height = (int)(MaterialMenuDrawable.dpToPx(resources, 40.0f) * (float)scale);
        this.iconWidth = MaterialMenuDrawable.dpToPx(resources, 20.0f) * (float)scale;
        this.circleRadius = MaterialMenuDrawable.dpToPx(resources, 18.0f) * (float)scale;
        this.strokeWidth = MaterialMenuDrawable.dpToPx(resources, stroke.strokeWidth) * (float)scale;
        this.sidePadding = ((float)this.width - this.iconWidth) / 2.0f;
        this.topPadding = ((float)this.height - 5.0f * this.dip3) / 2.0f;
        this.initPaint(color);
        this.initAnimations(transformDuration);
        this.materialMenuState = new MaterialMenuState();
    }

    private MaterialMenuDrawable(int color, Stroke stroke, long transformDuration, int width, int height, float iconWidth, float circleRadius, float strokeWidth, float dip1) {
        this.dip1 = dip1;
        this.dip2 = dip1 * 2.0f;
        this.dip3 = dip1 * 3.0f;
        this.dip4 = dip1 * 4.0f;
        this.dip8 = dip1 * 8.0f;
        this.diph = dip1 / 2.0f;
        this.stroke = stroke;
        this.width = width;
        this.height = height;
        this.iconWidth = iconWidth;
        this.circleRadius = circleRadius;
        this.strokeWidth = strokeWidth;
        this.sidePadding = ((float)width - iconWidth) / 2.0f;
        this.topPadding = ((float)height - 5.0f * this.dip3) / 2.0f;
        this.initPaint(color);
        this.initAnimations((int)transformDuration);
        this.materialMenuState = new MaterialMenuState();
    }

    private void initPaint(int color) {
        this.iconPaint.setAntiAlias(true);
        this.iconPaint.setStyle(Paint.Style.STROKE);
        this.iconPaint.setStrokeWidth(this.strokeWidth);
        this.iconPaint.setColor(color);
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setColor(color);
        this.circlePaint.setAlpha(200);
        this.setBounds(0, 0, this.width, this.height);
    }

    public void draw(Canvas canvas) {
        float ratio;
        if (!this.visible) {
            return;
        }
        float f = ratio = this.transformationValue <= 1.0f ? this.transformationValue : 2.0f - this.transformationValue;
        if (this.rtlEnabled) {
            canvas.save();
            canvas.scale(-1.0f, 1.0f, 0.0f, 0.0f);
            canvas.translate((float)(-this.getIntrinsicWidth()), 0.0f);
        }
        this.drawTopLine(canvas, ratio);
        this.drawMiddleLine(canvas, ratio);
        this.drawBottomLine(canvas, ratio);
        if (this.rtlEnabled) {
            canvas.restore();
        }
    }

    private void drawMiddleLine(Canvas canvas, float ratio) {
        canvas.restore();
        canvas.save();
        float rotation = 0.0f;
        float pivotX = this.width / 2;
        float pivotY = this.width / 2;
        float startX = this.sidePadding;
        float startY = this.topPadding + this.dip3 / 2.0f * 5.0f;
        float stopX = (float)this.width - this.sidePadding;
        float stopY = this.topPadding + this.dip3 / 2.0f * 5.0f;
        int alpha = 255;
        switch (this.animationState) {
            case BURGER_ARROW: {
                rotation = this.isMorphingForward() ? ratio * 180.0f : 180.0f + (1.0f - ratio) * 180.0f;
                stopX -= ratio * this.resolveStrokeModifier(ratio) / 2.0f;
                break;
            }
            case BURGER_X: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                break;
            }
            case ARROW_X: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                startX += (1.0f - ratio) * this.dip2;
                break;
            }
            case ARROW_CHECK: {
                rotation = this.isMorphingForward() ? ratio * 135.0f : 135.0f - 135.0f * (1.0f - ratio);
                startX += this.dip3 / 2.0f + this.dip4 - (1.0f - ratio) * this.dip2;
                stopX += ratio * this.dip1;
                pivotX = (float)(this.width / 2) + this.dip3 + this.diph;
                break;
            }
            case BURGER_CHECK: {
                rotation = ratio * 135.0f;
                startX += ratio * (this.dip4 + this.dip3 / 2.0f);
                stopX += ratio * this.dip1;
                pivotX = (float)(this.width / 2) + this.dip3 + this.diph;
                break;
            }
            case X_CHECK: {
                alpha = (int)(ratio * 255.0f);
                rotation = ratio * 135.0f;
                startX += ratio * (this.dip4 + this.dip3 / 2.0f);
                stopX += ratio * this.dip1;
                pivotX = (float)(this.width / 2) + this.dip3 + this.diph;
            }
        }
        this.iconPaint.setAlpha(alpha);
        canvas.rotate(rotation, pivotX, pivotY);
        canvas.drawLine(startX, startY, stopX, stopY, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    private void drawTopLine(Canvas canvas, float ratio) {
        canvas.save();
        float rotation = 0.0f;
        float pivotX = 0.0f;
        float pivotY = 0.0f;
        float rotation2 = 0.0f;
        float pivotX2 = (float)(this.width / 2) + this.dip3 / 2.0f;
        float pivotY2 = this.topPadding + this.dip2;
        float startX = this.sidePadding;
        float startY = this.topPadding + this.dip2;
        float stopX = (float)this.width - this.sidePadding;
        float stopY = this.topPadding + this.dip2;
        int alpha = 255;
        switch (this.animationState) {
            case BURGER_ARROW: {
                rotation = this.isMorphingForward() ? ratio * 225.0f : 225.0f + (1.0f - ratio) * 135.0f;
                pivotX = this.width / 2;
                pivotY = this.height / 2;
                stopX -= this.resolveStrokeModifier(ratio);
                startX += this.dip3 * ratio;
                break;
            }
            case BURGER_X: {
                rotation = 44.0f * ratio;
                rotation2 = 90.0f * ratio;
                pivotX = this.sidePadding + this.dip4;
                pivotY = this.topPadding + this.dip3;
                startX += this.dip3 * ratio;
                break;
            }
            case ARROW_X: {
                rotation = 225.0f + -181.0f * ratio;
                rotation2 = 90.0f * ratio;
                pivotX = (float)(this.width / 2) + (this.sidePadding + this.dip4 - (float)(this.width / 2)) * ratio;
                pivotY = (float)(this.height / 2) + (this.topPadding + this.dip3 - (float)(this.height / 2)) * ratio;
                stopX -= this.resolveStrokeModifier(ratio);
                startX += this.dip3;
                break;
            }
            case ARROW_CHECK: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                rotation = 225.0f;
                pivotX = this.width / 2;
                pivotY = this.height / 2;
                stopX -= this.resolveStrokeModifier(1.0f);
                startX += this.dip3;
                break;
            }
            case BURGER_CHECK: {
                alpha = (int)((1.0f - ratio) * 255.0f);
                break;
            }
            case X_CHECK: {
                rotation = 44.0f;
                rotation2 = 90.0f;
                pivotX = this.sidePadding + this.dip4;
                pivotY = this.topPadding + this.dip3;
                stopX += this.dip3 - this.dip3 * (1.0f - ratio);
                startX += this.dip3;
                alpha = (int)((1.0f - ratio) * 255.0f);
            }
        }
        this.iconPaint.setAlpha(alpha);
        canvas.rotate(rotation, pivotX, pivotY);
        canvas.rotate(rotation2, pivotX2, pivotY2);
        canvas.drawLine(startX, startY, stopX, stopY, this.iconPaint);
        this.iconPaint.setAlpha(255);
    }

    private void drawBottomLine(Canvas canvas, float ratio) {
        canvas.restore();
        canvas.save();
        float rotation = 0.0f;
        float pivotX = 0.0f;
        float pivotY = 0.0f;
        float rotation2 = 0.0f;
        float pivotX2 = (float)(this.width / 2) + this.dip3 / 2.0f;
        float pivotY2 = (float)this.height - this.topPadding - this.dip2;
        float startX = this.sidePadding;
        float startY = (float)this.height - this.topPadding - this.dip2;
        float stopX = (float)this.width - this.sidePadding;
        float stopY = (float)this.height - this.topPadding - this.dip2;
        switch (this.animationState) {
            case BURGER_ARROW: {
                rotation = this.isMorphingForward() ? 135.0f * ratio : 135.0f + (1.0f - ratio) * 225.0f;
                pivotX = this.width / 2;
                pivotY = this.height / 2;
                stopX = (float)this.width - this.sidePadding - this.resolveStrokeModifier(ratio);
                startX = this.sidePadding + this.dip3 * ratio;
                break;
            }
            case BURGER_X: {
                rotation2 = this.isMorphingForward() ? -90.0f * ratio : 90.0f * ratio;
                rotation = -44.0f * ratio;
                pivotX = this.sidePadding + this.dip4;
                pivotY = (float)this.height - this.topPadding - this.dip3;
                startX += this.dip3 * ratio;
                break;
            }
            case ARROW_X: {
                rotation = 135.0f + 181.0f * ratio;
                rotation2 = -90.0f * ratio;
                pivotX = (float)(this.width / 2) + (this.sidePadding + this.dip4 - (float)(this.width / 2)) * ratio;
                pivotY = (float)(this.height / 2) + ((float)(this.height / 2) - this.topPadding - this.dip3) * ratio;
                stopX -= this.resolveStrokeModifier(ratio);
                startX += this.dip3;
                break;
            }
            case ARROW_CHECK: {
                rotation = 135.0f + ratio * -90.0f;
                pivotX = (float)(this.width / 2) + this.dip3 * ratio;
                pivotY = (float)(this.height / 2) - this.dip3 * ratio;
                stopX -= this.resolveStrokeModifier(1.0f);
                startX += this.dip3 + (this.dip4 + this.dip1) * ratio;
                break;
            }
            case BURGER_CHECK: {
                rotation = ratio * 45.0f;
                pivotX = (float)(this.width / 2) + this.dip3 * ratio;
                pivotY = (float)(this.height / 2) - this.dip3 * ratio;
                startX += this.dip8 * ratio;
                stopX -= this.resolveStrokeModifier(ratio);
                break;
            }
            case X_CHECK: {
                rotation2 = -90.0f * (1.0f - ratio);
                rotation = -44.0f + 89.0f * ratio;
                pivotX = this.sidePadding + this.dip4 + ((float)(this.width / 2) + this.dip3 - this.sidePadding - this.dip4) * ratio;
                pivotY = (float)this.height - this.topPadding - this.dip3 + (this.topPadding + (float)(this.height / 2) - (float)this.height) * ratio;
                startX += this.dip8 - (this.dip4 + this.dip1) * (1.0f - ratio);
                stopX -= this.resolveStrokeModifier(1.0f - ratio);
            }
        }
        canvas.rotate(rotation, pivotX, pivotY);
        canvas.rotate(rotation2, pivotX2, pivotY2);
        canvas.drawLine(startX, startY, stopX, stopY, this.iconPaint);
    }

    private boolean isMorphingForward() {
        return this.transformationValue <= 1.0f;
    }

    private float resolveStrokeModifier(float ratio) {
        switch (this.stroke) {
            case REGULAR: {
                if (this.animationState == AnimationState.ARROW_X || this.animationState == AnimationState.X_CHECK) {
                    return this.dip3 - this.dip3 * ratio;
                }
                return ratio * this.dip3;
            }
            case THIN: {
                if (this.animationState == AnimationState.ARROW_X || this.animationState == AnimationState.X_CHECK) {
                    return this.dip3 + this.diph - (this.dip3 + this.diph) * ratio;
                }
                return ratio * (this.dip3 + this.diph);
            }
            case EXTRA_THIN: {
                if (this.animationState == AnimationState.ARROW_X || this.animationState == AnimationState.X_CHECK) {
                    return this.dip4 - (this.dip3 + this.dip1) * ratio;
                }
                return ratio * this.dip4;
            }
        }
        return 0.0f;
    }

    public void setAlpha(int alpha) {
        this.iconPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.iconPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -2;
    }

    public void setColor(int color) {
        this.iconPaint.setColor(color);
        this.circlePaint.setColor(color);
        this.invalidateSelf();
    }

    public void setTransformationDuration(int duration) {
        this.transformation.setDuration((long)duration);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.transformation.setInterpolator((TimeInterpolator)interpolator);
    }

    public void setAnimationListener(Animator.AnimatorListener listener) {
        if (this.animatorListener != null) {
            this.transformation.removeListener(this.animatorListener);
        }
        if (listener != null) {
            this.transformation.addListener(listener);
        }
        this.animatorListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconState(IconState iconState) {
        Object object = this.lock;
        synchronized (object) {
            if (this.transformationRunning) {
                this.transformation.cancel();
                this.transformationRunning = false;
            }
            if (this.currentIconState == iconState) {
                return;
            }
            switch (iconState) {
                case BURGER: {
                    this.animationState = AnimationState.BURGER_ARROW;
                    this.transformationValue = 0.0f;
                    break;
                }
                case ARROW: {
                    this.animationState = AnimationState.BURGER_ARROW;
                    this.transformationValue = 1.0f;
                    break;
                }
                case X: {
                    this.animationState = AnimationState.BURGER_X;
                    this.transformationValue = 1.0f;
                    break;
                }
                case CHECK: {
                    this.animationState = AnimationState.BURGER_CHECK;
                    this.transformationValue = 1.0f;
                }
            }
            this.currentIconState = iconState;
            this.invalidateSelf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateIconState(IconState state) {
        Object object = this.lock;
        synchronized (object) {
            if (this.transformationRunning) {
                this.transformation.end();
            }
            this.animatingIconState = state;
            this.start();
        }
    }

    public IconState setTransformationOffset(AnimationState animationState, float offset) {
        if (offset < 0.0f || offset > 2.0f) {
            throw new IllegalArgumentException(String.format("Value must be between %s and %s", Float.valueOf(0.0f), Float.valueOf(2.0f)));
        }
        this.animationState = animationState;
        boolean isFirstIcon = offset < 1.0f || offset == 2.0f;
        this.currentIconState = isFirstIcon ? animationState.getFirstState() : animationState.getSecondState();
        this.animatingIconState = isFirstIcon ? animationState.getSecondState() : animationState.getFirstState();
        this.setTransformationValue(Float.valueOf(offset));
        return this.currentIconState;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.invalidateSelf();
    }

    public void setRTLEnabled(boolean rtlEnabled) {
        this.rtlEnabled = rtlEnabled;
        this.invalidateSelf();
    }

    public IconState getIconState() {
        return this.currentIconState;
    }

    public boolean isDrawableVisible() {
        return this.visible;
    }

    public Float getTransformationValue() {
        return Float.valueOf(this.transformationValue);
    }

    public void setTransformationValue(Float value) {
        this.transformationValue = value.floatValue();
        this.invalidateSelf();
    }

    private void initAnimations(int transformDuration) {
        this.transformation = ObjectAnimator.ofFloat((Object)((Object)this), this.transformationProperty, (float[])new float[]{0.0f});
        this.transformation.setInterpolator((TimeInterpolator)new DecelerateInterpolator(3.0f));
        this.transformation.setDuration((long)transformDuration);
        this.transformation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MaterialMenuDrawable.this.transformationRunning = false;
                MaterialMenuDrawable.this.setIconState(MaterialMenuDrawable.this.animatingIconState);
            }
        });
    }

    private boolean resolveTransformation() {
        boolean isAnimatingCheck;
        boolean isCurrentBurger = this.currentIconState == IconState.BURGER;
        boolean isCurrentArrow = this.currentIconState == IconState.ARROW;
        boolean isCurrentX = this.currentIconState == IconState.X;
        boolean isCurrentCheck = this.currentIconState == IconState.CHECK;
        boolean isAnimatingBurger = this.animatingIconState == IconState.BURGER;
        boolean isAnimatingArrow = this.animatingIconState == IconState.ARROW;
        boolean isAnimatingX = this.animatingIconState == IconState.X;
        boolean bl = isAnimatingCheck = this.animatingIconState == IconState.CHECK;
        if (isCurrentBurger && isAnimatingArrow || isCurrentArrow && isAnimatingBurger) {
            this.animationState = AnimationState.BURGER_ARROW;
            return isCurrentBurger;
        }
        if (isCurrentArrow && isAnimatingX || isCurrentX && isAnimatingArrow) {
            this.animationState = AnimationState.ARROW_X;
            return isCurrentArrow;
        }
        if (isCurrentBurger && isAnimatingX || isCurrentX && isAnimatingBurger) {
            this.animationState = AnimationState.BURGER_X;
            return isCurrentBurger;
        }
        if (isCurrentArrow && isAnimatingCheck || isCurrentCheck && isAnimatingArrow) {
            this.animationState = AnimationState.ARROW_CHECK;
            return isCurrentArrow;
        }
        if (isCurrentBurger && isAnimatingCheck || isCurrentCheck && isAnimatingBurger) {
            this.animationState = AnimationState.BURGER_CHECK;
            return isCurrentBurger;
        }
        if (isCurrentX && isAnimatingCheck || isCurrentCheck && isAnimatingX) {
            this.animationState = AnimationState.X_CHECK;
            return isCurrentX;
        }
        throw new IllegalStateException(String.format("Animating from %s to %s is not supported", new Object[]{this.currentIconState, this.animatingIconState}));
    }

    public void start() {
        if (this.transformationRunning) {
            return;
        }
        if (this.animatingIconState != null && this.animatingIconState != this.currentIconState) {
            this.transformationRunning = true;
            boolean direction = this.resolveTransformation();
            this.transformation.setFloatValues(new float[]{direction ? 0.0f : 1.0f, direction ? 1.0f : 2.0f});
            this.transformation.start();
        }
        this.invalidateSelf();
    }

    public void stop() {
        if (this.isRunning() && this.transformation.isRunning()) {
            this.transformation.end();
        } else {
            this.transformationRunning = false;
            this.invalidateSelf();
        }
    }

    public boolean isRunning() {
        return this.transformationRunning;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public Drawable.ConstantState getConstantState() {
        this.materialMenuState.changingConfigurations = this.getChangingConfigurations();
        return this.materialMenuState;
    }

    public Drawable mutate() {
        this.materialMenuState = new MaterialMenuState();
        return this;
    }

    static float dpToPx(Resources resources, float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private final class MaterialMenuState
    extends Drawable.ConstantState {
        private int changingConfigurations;

        private MaterialMenuState() {
        }

        public Drawable newDrawable() {
            MaterialMenuDrawable drawable = new MaterialMenuDrawable(MaterialMenuDrawable.this.circlePaint.getColor(), MaterialMenuDrawable.this.stroke, MaterialMenuDrawable.this.transformation.getDuration(), MaterialMenuDrawable.this.width, MaterialMenuDrawable.this.height, MaterialMenuDrawable.this.iconWidth, MaterialMenuDrawable.this.circleRadius, MaterialMenuDrawable.this.strokeWidth, MaterialMenuDrawable.this.dip1);
            drawable.setIconState(MaterialMenuDrawable.this.animatingIconState != null ? MaterialMenuDrawable.this.animatingIconState : MaterialMenuDrawable.this.currentIconState);
            drawable.setVisible(MaterialMenuDrawable.this.visible);
            drawable.setRTLEnabled(MaterialMenuDrawable.this.rtlEnabled);
            return drawable;
        }

        public int getChangingConfigurations() {
            return this.changingConfigurations;
        }
    }

    public static enum Stroke {
        REGULAR(3),
        THIN(2),
        EXTRA_THIN(1);

        private final int strokeWidth;

        private Stroke(int strokeWidth) {
            this.strokeWidth = strokeWidth;
        }

        protected static Stroke valueOf(int strokeWidth) {
            switch (strokeWidth) {
                case 3: {
                    return REGULAR;
                }
                case 2: {
                    return THIN;
                }
                case 1: {
                    return EXTRA_THIN;
                }
            }
            return THIN;
        }
    }

    public static enum AnimationState {
        BURGER_ARROW,
        BURGER_X,
        ARROW_X,
        ARROW_CHECK,
        BURGER_CHECK,
        X_CHECK;


        public IconState getFirstState() {
            switch (this) {
                case BURGER_ARROW: {
                    return IconState.BURGER;
                }
                case BURGER_X: {
                    return IconState.BURGER;
                }
                case ARROW_X: {
                    return IconState.ARROW;
                }
                case ARROW_CHECK: {
                    return IconState.ARROW;
                }
                case BURGER_CHECK: {
                    return IconState.BURGER;
                }
                case X_CHECK: {
                    return IconState.X;
                }
            }
            return null;
        }

        public IconState getSecondState() {
            switch (this) {
                case BURGER_ARROW: {
                    return IconState.ARROW;
                }
                case BURGER_X: {
                    return IconState.X;
                }
                case ARROW_X: {
                    return IconState.X;
                }
                case ARROW_CHECK: {
                    return IconState.CHECK;
                }
                case BURGER_CHECK: {
                    return IconState.CHECK;
                }
                case X_CHECK: {
                    return IconState.CHECK;
                }
            }
            return null;
        }
    }

    public static enum IconState {
        BURGER,
        ARROW,
        X,
        CHECK;

    }
}

