/*
 * Decompiled with CFR 0.152.
 */
package com.balysv.materialmenu;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.balysv.materialmenu.MaterialMenu;
import com.balysv.materialmenu.MaterialMenuDrawable;
import com.balysv.materialmenu.R;

public abstract class MaterialMenuBase
implements MaterialMenu {
    private static final String STATE_KEY = "material_menu_icon_state";
    private MaterialMenuDrawable.IconState currentState = MaterialMenuDrawable.IconState.BURGER;
    private MaterialMenuDrawable drawable;

    public MaterialMenuBase(Activity activity, int color, MaterialMenuDrawable.Stroke stroke) {
        this(activity, color, stroke, 800);
    }

    public MaterialMenuBase(Activity activity, int color, MaterialMenuDrawable.Stroke stroke, int transformDuration) {
        this.drawable = new MaterialMenuDrawable((Context)activity, color, stroke, 1, transformDuration);
        this.setActionBarSettings(activity);
        if (this.providesActionBar()) {
            this.setupActionBar(activity);
        }
    }

    private void setupActionBar(Activity activity) {
        View iconView = this.getActionBarHomeView(activity);
        View upView = this.getActionBarUpView(activity);
        if (iconView == null || upView == null) {
            throw new IllegalStateException("Could not find ActionBar views");
        }
        ViewGroup.MarginLayoutParams iconParams = (ViewGroup.MarginLayoutParams)iconView.getLayoutParams();
        iconParams.bottomMargin = 0;
        iconParams.topMargin = 0;
        iconParams.leftMargin = 0;
        iconView.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        ViewGroup.MarginLayoutParams upParams = (ViewGroup.MarginLayoutParams)upView.getLayoutParams();
        upParams.leftMargin = activity.getResources().getDimensionPixelSize(R.dimen.mm_up_arrow_margin);
        upParams.rightMargin = 0;
        upView.setLayoutParams((ViewGroup.LayoutParams)upParams);
    }

    protected abstract void setActionBarSettings(Activity var1);

    protected abstract View getActionBarHomeView(Activity var1);

    protected abstract View getActionBarUpView(Activity var1);

    protected abstract boolean providesActionBar();

    @Override
    public final void setState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.getDrawable().setIconState(state);
    }

    @Override
    public final MaterialMenuDrawable.IconState getState() {
        return this.getDrawable().getIconState();
    }

    @Override
    public final void animateState(MaterialMenuDrawable.IconState state) {
        this.currentState = state;
        this.getDrawable().animateIconState(state);
    }

    @Override
    public final void animatePressedState(MaterialMenuDrawable.IconState state) {
        this.animateState(state);
    }

    @Override
    public final void setColor(int color) {
        this.getDrawable().setColor(color);
    }

    @Override
    public final void setVisible(boolean visible) {
        this.getDrawable().setVisible(visible);
    }

    @Override
    public final void setTransformationDuration(int duration) {
        this.getDrawable().setTransformationDuration(duration);
    }

    @Override
    public final void setInterpolator(Interpolator interpolator) {
        this.getDrawable().setInterpolator(interpolator);
    }

    @Override
    public final void setAnimationListener(Animator.AnimatorListener listener) {
        this.getDrawable().setAnimationListener(listener);
    }

    @Override
    public final void setRTLEnabled(boolean rtlEnabled) {
        this.getDrawable().setRTLEnabled(rtlEnabled);
    }

    @Override
    public final void setTransformationOffset(MaterialMenuDrawable.AnimationState animationState, float value) {
        this.currentState = this.getDrawable().setTransformationOffset(animationState, value);
    }

    @Override
    public final MaterialMenuDrawable getDrawable() {
        return this.drawable;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(STATE_KEY, this.currentState.name());
    }

    public void syncState(Bundle state) {
        if (state != null) {
            String iconStateName = state.getString(STATE_KEY);
            if (iconStateName == null) {
                iconStateName = MaterialMenuDrawable.IconState.BURGER.name();
            }
            this.setState(MaterialMenuDrawable.IconState.valueOf(iconStateName));
        }
    }
}

