/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.message;

import java.util.TreeMap;

public class BulkRecipient {
    private String emailAddress;
    private String friendlyName;
    private TreeMap<String, String> mergeData = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public BulkRecipient(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public BulkRecipient(String emailAddress, String friendlyName) {
        this.emailAddress = emailAddress;
        this.friendlyName = friendlyName;
    }

    public BulkRecipient(String emailAddress, TreeMap<String, String> mergeData) {
        this.emailAddress = emailAddress;
        this.mergeData = mergeData;
    }

    public BulkRecipient(String emailAddress, String friendlyName, TreeMap<String, String> mergeData) {
        this.emailAddress = emailAddress;
        this.friendlyName = friendlyName;
        this.mergeData = mergeData;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String value) {
        this.emailAddress = value;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String value) {
        this.friendlyName = value;
    }

    public TreeMap<String, String> getMergeData() {
        return this.mergeData;
    }

    public void setMergeData(TreeMap<String, String> value) {
        this.mergeData = value;
    }

    public void addMergeData(String field, String value) {
        this.mergeData.put(field, value);
    }

    public boolean isValid() {
        char[] badEmailCharacters;
        if (this.emailAddress == null || this.emailAddress.isEmpty()) {
            return false;
        }
        if (!this.emailAddress.contains("@") || !this.emailAddress.contains(".")) {
            return false;
        }
        if (this.emailAddress.length() > 320) {
            return false;
        }
        String[] parts = this.emailAddress.split("@");
        if (parts[0].trim().length() < 1 || parts[1].trim().length() < 1) {
            return false;
        }
        for (char c : badEmailCharacters = new char[]{',', ' ', ';', '\u00bf'}) {
            if (this.emailAddress.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.friendlyName == null || this.friendlyName.isEmpty()) {
            return this.emailAddress;
        }
        return String.format("%s <%s>", this.friendlyName, this.emailAddress);
    }
}

