/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.core.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.socketLabs.injectionApi.core.serialization.AddressJson;
import com.socketLabs.injectionApi.core.serialization.AttachmentJson;
import com.socketLabs.injectionApi.core.serialization.CustomHeaderJson;
import com.socketLabs.injectionApi.core.serialization.InjectionRequest;
import com.socketLabs.injectionApi.core.serialization.MergeDataJson;
import com.socketLabs.injectionApi.core.serialization.MergeFieldJson;
import com.socketLabs.injectionApi.core.serialization.MessageJson;
import com.socketLabs.injectionApi.core.serialization.MetadataJson;
import com.socketLabs.injectionApi.message.Attachment;
import com.socketLabs.injectionApi.message.BasicMessage;
import com.socketLabs.injectionApi.message.BulkMessage;
import com.socketLabs.injectionApi.message.BulkRecipient;
import com.socketLabs.injectionApi.message.CustomHeader;
import com.socketLabs.injectionApi.message.EmailAddress;
import com.socketLabs.injectionApi.message.MessageBase;
import com.socketLabs.injectionApi.message.Metadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InjectionRequestFactory {
    private int serverId;
    private String apiKey;
    private ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public InjectionRequestFactory(int serverId, String apiKey) {
        this.serverId = serverId;
        this.apiKey = apiKey;
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String GenerateRequest(BulkMessage bulkMessage) throws IOException {
        ArrayList<MessageJson> messageJsonList = new ArrayList<MessageJson>();
        MessageJson messageJson = this.generateBaseMessage(bulkMessage);
        ArrayList<AddressJson> to = new ArrayList<AddressJson>();
        to.add(new AddressJson("%%DeliveryAddress%%", "%%RecipientName%%"));
        messageJson.setTo(to);
        messageJson.setMergeData(this.populateMergeData(bulkMessage.getGlobalMergeData(), bulkMessage.getTo()));
        messageJsonList.add(messageJson);
        return this.GetAsJson(new InjectionRequest(this.serverId, this.apiKey, messageJsonList));
    }

    public String GenerateRequest(BasicMessage basicMessage) throws IOException {
        ArrayList<MessageJson> messageJsonList = new ArrayList<MessageJson>();
        MessageJson messageJson = this.generateBaseMessage(basicMessage);
        messageJson.setTo(this.populateEmailList(basicMessage.getTo()));
        messageJson.setCc(this.populateEmailList(basicMessage.getCc()));
        messageJson.setBcc(this.populateEmailList(basicMessage.getBcc()));
        messageJsonList.add(messageJson);
        return this.GetAsJson(new InjectionRequest(this.serverId, this.apiKey, messageJsonList));
    }

    private String GetAsJson(InjectionRequest request) throws IOException {
        return this.mapper.writeValueAsString((Object)request);
    }

    private MessageJson generateBaseMessage(MessageBase messageBase) {
        MessageJson messageJson = new MessageJson();
        messageJson.setSubject(messageBase.getSubject());
        messageJson.setPlainTextBody(messageBase.getPlainTextBody());
        messageJson.setHtmlBody(messageBase.getHtmlBody());
        messageJson.setAmpBody(messageBase.getAmpBody());
        messageJson.setMailingId(messageBase.getMailingId());
        messageJson.setMessageId(messageBase.getMessageId());
        messageJson.setCharSet(messageBase.getCharSet());
        messageJson.setFrom(new AddressJson(messageBase.getFrom().getEmailAddress(), messageBase.getFrom().getFriendlyName()));
        messageJson.setCustomHeaders(this.populateCustomHeaders(messageBase.getCustomHeaders()));
        messageJson.setAttachments(this.populateAttachments(messageBase.getAttachments()));
        messageJson.setMetadata(this.populateMetadata(messageBase.getMetadata()));
        messageJson.setTags(messageBase.getTags());
        if (messageBase.getReplyTo() != null) {
            messageJson.setReplyTo(new AddressJson(messageBase.getReplyTo().getEmailAddress(), messageBase.getReplyTo().getFriendlyName()));
        }
        if (messageBase.getApiTemplate() != null) {
            messageJson.setApiTemplate(String.valueOf(messageBase.getApiTemplate()));
        }
        return messageJson;
    }

    private List<CustomHeaderJson> populateCustomHeaders(List<CustomHeader> baseCustomHeaders) {
        if (baseCustomHeaders == null) {
            return null;
        }
        ArrayList<CustomHeaderJson> customHeaderJson = new ArrayList<CustomHeaderJson>();
        for (CustomHeader baseCustomHeader : baseCustomHeaders) {
            customHeaderJson.add(new CustomHeaderJson(baseCustomHeader.getName(), baseCustomHeader.getValue()));
        }
        return customHeaderJson;
    }

    private List<AttachmentJson> populateAttachments(List<Attachment> baseAttachments) {
        if (baseAttachments == null) {
            return null;
        }
        ArrayList<AttachmentJson> attachments = new ArrayList<AttachmentJson>();
        for (Attachment baseAttachment : baseAttachments) {
            AttachmentJson attachment = new AttachmentJson();
            attachment.setContent(baseAttachment.getContent());
            attachment.setContentId(baseAttachment.getContentId());
            attachment.setMimeType(baseAttachment.getMimeType());
            attachment.setName(baseAttachment.getName());
            attachment.setCustomHeaderJsons(this.populateCustomHeaders(baseAttachment.getCustomHeaders()));
            attachments.add(attachment);
        }
        return attachments;
    }

    private List<MetadataJson> populateMetadata(List<Metadata> baseMetadata) {
        if (baseMetadata == null) {
            return null;
        }
        ArrayList<MetadataJson> metadataJson = new ArrayList<MetadataJson>();
        for (Metadata baseMetadataItem : baseMetadata) {
            metadataJson.add(new MetadataJson(baseMetadataItem.getKey(), baseMetadataItem.getValue()));
        }
        return metadataJson;
    }

    private List<AddressJson> populateEmailList(List<EmailAddress> baseTo) {
        if (baseTo == null) {
            return null;
        }
        ArrayList<AddressJson> addresses = new ArrayList<AddressJson>();
        for (EmailAddress baseAddress : baseTo) {
            AddressJson address = new AddressJson(baseAddress.getEmailAddress(), baseAddress.getFriendlyName());
            addresses.add(address);
        }
        return addresses;
    }

    private MergeDataJson populateMergeData(Map<String, String> global, List<BulkRecipient> recipients) {
        ArrayList<List<MergeFieldJson>> perMessageMergeFields = new ArrayList<List<MergeFieldJson>>();
        for (BulkRecipient recipient : recipients) {
            List<MergeFieldJson> mergeFieldJsonList = this.generateMergeFieldList(recipient.getMergeData());
            mergeFieldJsonList.add(new MergeFieldJson("DeliveryAddress", recipient.getEmailAddress()));
            if (recipient.getFriendlyName() != null) {
                mergeFieldJsonList.add(new MergeFieldJson("RecipientName", recipient.getFriendlyName()));
            }
            perMessageMergeFields.add(mergeFieldJsonList);
        }
        return new MergeDataJson(perMessageMergeFields, this.generateMergeFieldList(global));
    }

    private List<MergeFieldJson> generateMergeFieldList(Map<String, String> mergeData) {
        ArrayList<MergeFieldJson> mergeFieldJsonList = new ArrayList<MergeFieldJson>();
        for (Map.Entry<String, String> entry : mergeData.entrySet()) {
            mergeFieldJsonList.add(new MergeFieldJson(entry.getKey(), entry.getValue()));
        }
        return mergeFieldJsonList;
    }
}

