/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.core;

import com.socketLabs.injectionApi.core.ApiKeyParseResult;

public class ApiKeyParser {
    public ApiKeyParseResult Parse(String wholeApiKey) {
        if (wholeApiKey == null || wholeApiKey.length() == 0) {
            return ApiKeyParseResult.InvalidEmptyOrWhitespace;
        }
        if (wholeApiKey.length() != 61) {
            return ApiKeyParseResult.InvalidKeyLength;
        }
        if (wholeApiKey.indexOf(46) == -1) {
            return ApiKeyParseResult.InvalidKeyFormat;
        }
        int publicPartEnd = wholeApiKey.substring(0, 50).indexOf(46);
        if (publicPartEnd == -1) {
            return ApiKeyParseResult.InvalidUnableToExtractPublicPart;
        }
        String publicPart = wholeApiKey.substring(0, publicPartEnd);
        if (publicPart.length() != 20) {
            return ApiKeyParseResult.InvalidPublicPartLength;
        }
        if (wholeApiKey.length() <= publicPartEnd + 1) {
            return ApiKeyParseResult.InvalidUnableToExtractSecretPart;
        }
        String privatePart = wholeApiKey.substring(publicPartEnd + 1);
        if (privatePart.length() != 40) {
            return ApiKeyParseResult.InvalidSecretPartLength;
        }
        return ApiKeyParseResult.Success;
    }
}

