/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.message;

import com.socketLabs.injectionApi.message.Attachment;
import com.socketLabs.injectionApi.message.BulkRecipient;
import com.socketLabs.injectionApi.message.CustomHeader;
import com.socketLabs.injectionApi.message.EmailAddress;
import com.socketLabs.injectionApi.message.MessageBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class BulkMessage
implements MessageBase {
    private List<BulkRecipient> to = new ArrayList<BulkRecipient>();
    private TreeMap<String, String> globalMergeData = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private String subject;
    private String plainTextBody;
    private String htmlBody;
    private String ampBody;
    @Nullable
    private Integer apiTemplate;
    private String mailingId;
    private String messageId;
    private EmailAddress from;
    private EmailAddress replyTo;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private String charSet;
    private List<CustomHeader> customHeaders = new ArrayList<CustomHeader>();

    public List<BulkRecipient> getTo() {
        return this.to;
    }

    public void setTo(List<BulkRecipient> value) {
        this.to = value;
    }

    public void addToRecipient(String emailAddress) {
        this.to.add(new BulkRecipient(emailAddress));
    }

    public void addToRecipient(String emailAddress, String name) {
        this.to.add(new BulkRecipient(emailAddress, name));
    }

    public void addToRecipient(BulkRecipient bulkRecipient) {
        this.to.add(bulkRecipient);
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String value) {
        this.subject = value;
    }

    @Override
    public String getPlainTextBody() {
        return this.plainTextBody;
    }

    @Override
    public void setPlainTextBody(String value) {
        this.plainTextBody = value;
    }

    @Override
    public String getHtmlBody() {
        return this.htmlBody;
    }

    @Override
    public void setHtmlBody(String value) {
        this.htmlBody = value;
    }

    @Override
    public String getAmpBody() {
        return this.ampBody;
    }

    @Override
    public void setAmpBody(String value) {
        this.ampBody = value;
    }

    @Override
    @Nullable
    public Integer getApiTemplate() {
        return this.apiTemplate;
    }

    @Override
    public void setApiTemplate(@Nullable Integer value) {
        this.apiTemplate = value;
    }

    @Override
    public String getMailingId() {
        return this.mailingId;
    }

    @Override
    public void setMailingId(String value) {
        this.mailingId = value;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public void setMessageId(String value) {
        this.messageId = value;
    }

    @Override
    public EmailAddress getFrom() {
        return this.from;
    }

    @Override
    public void setFrom(EmailAddress value) {
        this.from = value;
    }

    @Override
    public EmailAddress getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setReplyTo(EmailAddress value) {
        this.replyTo = value;
    }

    @Override
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(List<Attachment> value) {
        this.attachments = value;
    }

    public void addAttachments(String fileName) throws IOException {
        this.attachments.add(new Attachment(fileName));
    }

    public void addAttachments(Attachment attachment) {
        this.attachments.add(attachment);
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(String value) {
        this.charSet = value;
    }

    @Override
    public List<CustomHeader> getCustomHeaders() {
        return this.customHeaders;
    }

    @Override
    public void setCustomHeaders(List<CustomHeader> value) {
        this.customHeaders = value;
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.add(new CustomHeader(name, value));
    }

    public void addCustomHeader(CustomHeader header) {
        this.customHeaders.add(header);
    }

    public TreeMap<String, String> getGlobalMergeData() {
        return this.globalMergeData;
    }

    public void setGlobalMergeData(TreeMap<String, String> value) {
        this.globalMergeData = value;
    }

    public void addGlobalMergeData(String field, String value) {
        this.globalMergeData.put(field, value);
    }

    public String toString() {
        return String.format("Recipients: %d, Subject, %s", this.to.size(), this.subject);
    }
}

