/*
 * Decompiled with CFR 0.152.
 */
package com.socketLabs.injectionApi.core.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.socketLabs.injectionApi.SendResponse;
import com.socketLabs.injectionApi.SendResult;
import com.socketLabs.injectionApi.core.serialization.InjectionResponseDto;
import java.io.IOException;
import okhttp3.Response;

public class InjectionResponseParser {
    public SendResponse Parse(Response response) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        InjectionResponseDto injectionResponse = (InjectionResponseDto)mapper.readValue(response.body().string(), InjectionResponseDto.class);
        SendResult resultEnum = this.DetermineSendResult(injectionResponse, response.networkResponse().code());
        SendResponse newResponse = new SendResponse(resultEnum);
        newResponse.setTransactionReceipt(injectionResponse.getTransactionReceipt());
        if (resultEnum == SendResult.Warning && injectionResponse.getMessageResults() != null && injectionResponse.getMessageResults().size() > 0) {
            SendResult r = SendResult.fromString(injectionResponse.getMessageResults().get(0).getErrorCode());
            newResponse.setResult(r);
        }
        if (injectionResponse.getMessageResults() != null && injectionResponse.getMessageResults().size() > 0) {
            newResponse.setAddressResults(injectionResponse.getMessageResults().get(0).getAddressResults());
        }
        return newResponse;
    }

    private SendResult DetermineSendResult(InjectionResponseDto responseDto, int responseCode) {
        switch (responseCode) {
            case 200: {
                SendResult r = SendResult.fromString(responseDto.getErrorCode());
                if (r == null) {
                    return SendResult.UnknownError;
                }
                return r;
            }
            case 500: {
                return SendResult.InternalError;
            }
            case 408: {
                return SendResult.Timeout;
            }
            case 401: {
                return SendResult.InvalidAuthentication;
            }
        }
        return SendResult.UnknownError;
    }
}

