/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.maven.model;

import com.societegenerale.commons.plugin.maven.model.MavenConfigurableRule;
import com.societegenerale.commons.plugin.model.Rules;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class MavenRules {
    @Parameter(property="preConfiguredRules")
    private List<String> preConfiguredRules = new ArrayList<String>();
    @Parameter(property="configurableRules")
    private List<MavenConfigurableRule> configurableRules = new ArrayList<MavenConfigurableRule>();

    public MavenRules() {
    }

    public MavenRules(List<String> preConfiguredRules, List<MavenConfigurableRule> configurableRules) {
        this.preConfiguredRules = preConfiguredRules;
        this.configurableRules = configurableRules;
    }

    public Rules toCoreRules() {
        return new Rules(this.preConfiguredRules, this.configurableRules.stream().map(e -> e.toCoreConfigurableRule()).collect(Collectors.toList()));
    }

    public List<String> getPreConfiguredRules() {
        return this.preConfiguredRules;
    }

    public List<MavenConfigurableRule> getConfigurableRules() {
        return this.configurableRules;
    }

    public void setPreConfiguredRules(List<String> preConfiguredRules) {
        this.preConfiguredRules = preConfiguredRules;
    }

    public void setConfigurableRules(List<MavenConfigurableRule> configurableRules) {
        this.configurableRules = configurableRules;
    }
}

