/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.maven;

import com.societegenerale.commons.plugin.Log;
import com.societegenerale.commons.plugin.maven.MavenLogAdapter;
import com.societegenerale.commons.plugin.maven.MavenScopePathProvider;
import com.societegenerale.commons.plugin.maven.model.MavenRules;
import com.societegenerale.commons.plugin.model.Rules;
import com.societegenerale.commons.plugin.service.RuleInvokerService;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="arch-test", requiresDependencyResolution=ResolutionScope.TEST)
public class ArchUnitMojo
extends AbstractMojo {
    @Parameter(defaultValue="false", property="archunit.skip", required=false)
    private boolean skip;
    @Parameter(property="excludedPaths")
    private List<String> excludedPaths = Collections.emptyList();
    @Parameter(property="rules")
    private MavenRules rules;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(property="noFailOnError", defaultValue="false")
    private boolean noFailOnError;
    private RuleInvokerService ruleInvokerService;
    private static final String PREFIX_ARCH_VIOLATION_MESSAGE = "ArchUnit Maven plugin reported architecture failures listed below :";

    public MavenRules getRules() {
        return this.rules;
    }

    public void execute() throws MojoFailureException {
        String ruleFailureMessage;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        Rules coreRules = this.rules.toCoreRules();
        if (!coreRules.isValid()) {
            throw new MojoFailureException("Arch unit Plugin should have at least one preconfigured/configurable rule");
        }
        if ("pom".equals(this.mavenProject.getPackaging())) {
            this.getLog().debug((CharSequence)"module packaging is 'pom', so skipping execution");
            return;
        }
        try {
            this.configureContextClassLoader();
            MavenLogAdapter mavenLogAdapter = new MavenLogAdapter(this.getLog());
            this.ruleInvokerService = new RuleInvokerService((Log)mavenLogAdapter, (ScopePathProvider)new MavenScopePathProvider(this.mavenProject), this.excludedPaths, this.projectBuildDir);
            ruleFailureMessage = this.ruleInvokerService.invokeRules(coreRules);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        if (!StringUtils.isEmpty((CharSequence)ruleFailureMessage)) {
            if (!this.noFailOnError) {
                throw new MojoFailureException(PREFIX_ARCH_VIOLATION_MESSAGE + ruleFailureMessage);
            }
            this.getLog().info((CharSequence)(PREFIX_ARCH_VIOLATION_MESSAGE + ruleFailureMessage));
        }
    }

    private void configureContextClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        List elements = this.mavenProject.getTestClasspathElements();
        for (String element : elements) {
            urls.add(new File(element).toURI().toURL());
        }
        URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    void setProjectBuildDir(String projectBuildDir) {
        this.projectBuildDir = projectBuildDir;
    }
}

