/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.gradle;

import com.societegenerale.commons.plugin.Log;
import com.societegenerale.commons.plugin.gradle.ArchUnitGradleConfig;
import com.societegenerale.commons.plugin.gradle.GradleLogAdapter;
import com.societegenerale.commons.plugin.gradle.WorkerAction;
import com.societegenerale.commons.plugin.gradle.WorkerActionParams;
import com.societegenerale.commons.plugin.model.Rules;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.LoggerFactory;

public abstract class ArchUnitRulesTask
extends DefaultTask {
    private final Log logger = new GradleLogAdapter(LoggerFactory.getLogger(ArchUnitRulesTask.class));

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    public abstract Property<ArchUnitGradleConfig> getArchUnitGradleConfig();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public void checkRules() {
        ArchUnitGradleConfig archUnitGradleConfig = (ArchUnitGradleConfig)this.getArchUnitGradleConfig().get();
        if (archUnitGradleConfig.isSkip()) {
            this.logger.warn("Rule checking has been skipped!");
            return;
        }
        Rules rules = archUnitGradleConfig.getRules();
        if (!rules.isValid()) {
            throw new GradleException("Arch unit Gradle Plugin should have at least one preconfigured/configurable rule!");
        }
        WorkQueue queue = this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getClasspath()}));
        queue.submit(WorkerAction.class, params -> {
            params.getMainClassesPath().set((Object)(archUnitGradleConfig.getBuildPath() + "/classes/java/main"));
            params.getTestClassesPath().set((Object)(archUnitGradleConfig.getBuildPath() + "/classes/java/test"));
            params.getProjectBuildDirPath().set((Object)archUnitGradleConfig.getBuildPath());
            params.getPreConfiguredRules().addAll(archUnitGradleConfig.getPreConfiguredRules());
            params.getConfigurableRules().addAll((Iterable)archUnitGradleConfig.getConfigurableRules().stream().map(configurableRule -> {
                WorkerActionParams.ApplyOn applyOn = new WorkerActionParams.ApplyOn();
                applyOn.packageName = configurableRule.getApplyOn().getPackageName();
                applyOn.scope = configurableRule.getApplyOn().getScope();
                WorkerActionParams.ConfigurableRule ret = new WorkerActionParams.ConfigurableRule();
                ret.rule = configurableRule.getRule();
                ret.applyOn = applyOn;
                ret.checks.addAll(configurableRule.getChecks());
                ret.skip = configurableRule.isSkip();
                return ret;
            }).collect(Collectors.toList()));
        });
    }
}

