/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.gradle;

import com.societegenerale.commons.plugin.gradle.ArchUnitGradleConfig;
import com.societegenerale.commons.plugin.gradle.ArchUnitRulesTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;

public class ArchUnitGradlePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Configuration conf = (Configuration)project.getConfigurations().create("archUnitExtraLib");
        ArchUnitGradleConfig archUnitGradleConfig = (ArchUnitGradleConfig)project.getExtensions().create("archUnit", ArchUnitGradleConfig.class, new Object[]{project});
        ArchUnitRulesTask archUnitTask = (ArchUnitRulesTask)project.getTasks().create("checkRules", ArchUnitRulesTask.class);
        archUnitTask.setGroup("verification");
        archUnitTask.getClasspath().from(new Object[]{conf});
        archUnitTask.getArchUnitGradleConfig().convention((Object)archUnitGradleConfig);
        Task checkTask = this.findExistingTaskOrFailOtherwise("check", project);
        Task testTask = this.findExistingTaskOrFailOtherwise("test", project);
        checkTask.dependsOn(new Object[]{archUnitTask});
        archUnitTask.mustRunAfter(new Object[]{testTask});
    }

    private Task findExistingTaskOrFailOtherwise(String taskName, Project project) {
        Task taskToFind = (Task)project.getTasks().findByName(taskName);
        if (taskToFind == null) {
            throw new GradleException("can't find the '" + taskName + "' task on which archUnitGradle task will depend - please check Gradle java plugin is applied");
        }
        return taskToFind;
    }
}

