/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.gradle;

import com.societegenerale.commons.plugin.model.ApplyOn;
import com.societegenerale.commons.plugin.model.ConfigurableRule;
import com.societegenerale.commons.plugin.model.Rules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Project;

public class ArchUnitGradleConfig {
    private List<ConfigurableRule> configurableRules = new ArrayList<ConfigurableRule>();
    private List<String> preConfiguredRules = new ArrayList<String>();
    private List<String> excludedPaths = new ArrayList<String>();
    private Project project;
    private boolean skip = false;

    public ArchUnitGradleConfig(Project project) {
        this.project = project;
    }

    public void setPreConfiguredRules(List<String> preConfiguredRules) {
        this.preConfiguredRules = preConfiguredRules;
    }

    public void setConfigurableRules(List<ConfigurableRule> configurableRules) {
        this.configurableRules = configurableRules;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public ApplyOn applyOn(String packageName, String scope) {
        return new ApplyOn(packageName, scope);
    }

    public List<String> getPreConfiguredRules() {
        return this.preConfiguredRules;
    }

    public List<ConfigurableRule> getConfigurableRules() {
        return this.configurableRules;
    }

    public List<String> check(String ... checks) {
        return Arrays.asList(checks);
    }

    public Rules getRules() {
        return new Rules(this.preConfiguredRules, this.configurableRules);
    }

    public ConfigurableRule configurableRule(String rule, ApplyOn applyOn, List<String> checks) {
        return new ConfigurableRule(rule, applyOn, checks, false);
    }

    public ConfigurableRule configurableRule(String rule, ApplyOn applyOn) {
        return new ConfigurableRule(rule, applyOn, new ArrayList(), false);
    }

    public boolean isSkip() {
        return this.skip;
    }

    public String getBuildPath() {
        return this.project.getBuildDir().toString();
    }

    public List<String> getExcludedPaths() {
        return this.excludedPaths;
    }

    public void setExcludedPaths(List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }
}

