/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.utils;

import com.societegenerale.commons.plugin.Log;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.core.importer.Location;
import java.net.URI;
import javax.annotation.Nonnull;

public class ExclusionImportOption
implements ImportOption {
    private static final String CLASS = ".class";
    private final URI patternToExcludeDirectoryBased;
    private final Log log;

    public ExclusionImportOption(Log log, @Nonnull String patternToExclude) {
        this.log = log;
        log.debug("configuring a pattern to exclude : " + patternToExclude);
        this.patternToExcludeDirectoryBased = this.toUri(patternToExclude);
        log.debug("\t pattern converted into : " + this.patternToExcludeDirectoryBased.toString());
    }

    public boolean includes(Location location) {
        return location != null && !location.contains(this.patternToExcludeDirectoryBased.toString());
    }

    private URI toUri(@Nonnull String excludePath) {
        boolean excludePathEndsWithDotClass = excludePath.endsWith(CLASS);
        String stringToConvert = excludePath;
        if (excludePathEndsWithDotClass) {
            stringToConvert = excludePath.substring(0, excludePath.length() - CLASS.length());
        }
        stringToConvert = stringToConvert.contains(".") ? stringToConvert.replaceAll("\\.", "/") : stringToConvert.replaceAll("\\\\", "/");
        if (excludePathEndsWithDotClass) {
            stringToConvert = stringToConvert.concat(CLASS);
        }
        return URI.create(stringToConvert);
    }
}

