/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.utils;

import com.societegenerale.commons.plugin.Log;
import com.societegenerale.commons.plugin.model.RootClassFolder;
import com.societegenerale.commons.plugin.utils.ExclusionImportOption;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;

public class ArchUtils {
    private static Log log;

    public ArchUtils(Log log) {
        ArchUtils.log = log;
    }

    public static JavaClasses importAllClassesInPackage(RootClassFolder rootClassFolder, String packagePath) {
        return ArchUtils.importAllClassesInPackage(rootClassFolder, packagePath, Collections.emptyList());
    }

    public static JavaClasses importAllClassesInPackage(RootClassFolder rootClassFolder, String packagePath, Collection<String> excludedPaths) {
        if (log == null) {
            throw new IllegalStateException("please make sure you instantiate " + ArchUtils.class + " with a proper " + Log.class + " before calling this static method");
        }
        Path classesPath = Paths.get(rootClassFolder.getValue() + packagePath, new String[0]);
        if (!classesPath.toFile().exists()) {
            StringBuilder warnMessage = new StringBuilder("Classpath ").append(classesPath.toFile()).append(" doesn't exist : loading all classes from root, ie ").append(rootClassFolder.getValue()).append(" even though it's probably not what you want to achieve.").append(" Enable debug logs in your build to see the list of actual resources being loaded and analyzed by the plugin.");
            log.warn(warnMessage.toString());
            log.debug("existing folders and files under root project : ");
            try {
                Files.walk(Paths.get(rootClassFolder.getValue(), new String[0]), new FileVisitOption[0]).forEach(f -> log.debug(f.toFile().getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            classesPath = Paths.get(rootClassFolder.getValue(), new String[0]);
        } else if (log.isDebugEnabled()) {
            try {
                log.debug("loading classes from a location that exists : " + classesPath.toFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (log.isDebugEnabled()) {
            ClassFileImporter classFileImporterForDebug = new ClassFileImporter();
            JavaClasses classesImportedBeforeExclusion = classFileImporterForDebug.importPath(classesPath);
            log.debug("nb classes imported before exclusion : " + classesImportedBeforeExclusion.size());
        }
        ClassFileImporter classFileImporter = new ClassFileImporter();
        for (String excludedPath : excludedPaths) {
            ExclusionImportOption exclusionImportOption = new ExclusionImportOption(log, excludedPath);
            classFileImporter = classFileImporter.withImportOption((ImportOption)exclusionImportOption);
        }
        JavaClasses classesImportedAfterExclusionProcessing = classFileImporter.importPath(classesPath);
        if (log.isDebugEnabled()) {
            log.debug("nb classes imported after exclusion : " + classesImportedAfterExclusionProcessing.size());
        }
        return classesImportedAfterExclusionProcessing;
    }
}

