/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.service;

import com.societegenerale.commons.plugin.Log;
import com.societegenerale.commons.plugin.model.ConfigurableRule;
import com.societegenerale.commons.plugin.model.RootClassFolder;
import com.societegenerale.commons.plugin.model.Rules;
import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.DefaultScopePathProvider;
import com.societegenerale.commons.plugin.service.DotsToSlashesReplacer;
import com.societegenerale.commons.plugin.service.ExcludedPathsPreProcessor;
import com.societegenerale.commons.plugin.service.InvokableRules;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.societegenerale.commons.plugin.utils.ReflectionUtils;
import com.tngtech.archunit.core.domain.JavaClasses;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class RuleInvokerService {
    private static final String EXECUTE_METHOD_NAME = "execute";
    private Log log;
    private ArchUtils archUtils;
    private ScopePathProvider scopePathProvider = new DefaultScopePathProvider();
    private Collection<String> excludedPaths = Collections.emptySet();

    public RuleInvokerService(Log log) {
        this.log = log;
        this.archUtils = new ArchUtils(log);
    }

    public RuleInvokerService(Log log, ScopePathProvider scopePathProvider) {
        this.log = log;
        this.archUtils = new ArchUtils(log);
        this.scopePathProvider = scopePathProvider;
    }

    public RuleInvokerService(Log log, ScopePathProvider scopePathProvider, Collection<String> excludedPaths, String projectBuildDir) {
        this.log = log;
        this.archUtils = new ArchUtils(log);
        this.scopePathProvider = scopePathProvider;
        this.excludedPaths = new ExcludedPathsPreProcessor().processExcludedPaths(log, projectBuildDir, excludedPaths);
    }

    public String invokeRules(Rules rules) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        String errorMessage;
        StringBuilder errorListBuilder = new StringBuilder();
        for (String string : rules.getPreConfiguredRules()) {
            errorMessage = this.invokePreConfiguredRule(string);
            errorListBuilder.append(this.prepareErrorMessageForRuleFailures(string, errorMessage));
        }
        for (ConfigurableRule configurableRule : rules.getConfigurableRules()) {
            errorMessage = this.invokeConfigurableRules(configurableRule);
            errorListBuilder.append(this.prepareErrorMessageForRuleFailures(configurableRule.getRule(), errorMessage));
        }
        return errorListBuilder.toString();
    }

    private String invokePreConfiguredRule(String ruleClassName) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        ArchRuleTest ruleToExecute;
        Class<?> ruleClass = ReflectionUtils.loadClassWithContextClassLoader(ruleClassName);
        try {
            ruleToExecute = (ArchRuleTest)ruleClass.getConstructor(Log.class).newInstance(this.log);
        }
        catch (NoSuchMethodException e) {
            ruleToExecute = (ArchRuleTest)ruleClass.newInstance();
        }
        String errorMessage = "";
        try {
            Method method = ruleClass.getDeclaredMethod(EXECUTE_METHOD_NAME, String.class, ScopePathProvider.class, Collection.class);
            method.invoke((Object)ruleToExecute, "", this.scopePathProvider, this.excludedPaths);
        }
        catch (ReflectiveOperationException re) {
            errorMessage = re.getCause().toString();
        }
        return errorMessage;
    }

    private String invokeConfigurableRules(ConfigurableRule rule) {
        if (rule.isSkip()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Skipping rule " + rule.getRule());
            }
            return "";
        }
        InvokableRules invokableRules = InvokableRules.of(rule.getRule(), rule.getChecks(), this.log);
        String fullPathFromRootTopackage = this.getPackageNameOnWhichToApplyRules(rule);
        this.log.info("invoking ConfigurableRule " + rule.toString() + " on " + fullPathFromRootTopackage);
        JavaClasses classes = ArchUtils.importAllClassesInPackage(new RootClassFolder(""), fullPathFromRootTopackage, this.excludedPaths);
        InvokableRules.InvocationResult result = invokableRules.invokeOn(classes);
        return result.getMessage();
    }

    private String getPackageNameOnWhichToApplyRules(ConfigurableRule rule) {
        StringBuilder packageNameBuilder = new StringBuilder();
        if (rule.getApplyOn() != null) {
            if (rule.getApplyOn().getScope() != null && "test".equals(rule.getApplyOn().getScope())) {
                packageNameBuilder.append(this.scopePathProvider.getTestClassesPath().getValue());
            } else {
                packageNameBuilder.append(this.scopePathProvider.getMainClassesPath().getValue());
            }
            if (!packageNameBuilder.toString().endsWith("/")) {
                packageNameBuilder.append("/");
            }
            if (rule.getApplyOn().getPackageName() != null) {
                packageNameBuilder.append(DotsToSlashesReplacer.replace(rule.getApplyOn().getPackageName()));
            }
        }
        return packageNameBuilder.toString();
    }

    private String prepareErrorMessageForRuleFailures(String rule, String errorMessage) {
        StringBuilder errorBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            errorBuilder.append("Rule Violated - ").append(rule).append(System.lineSeparator()).append(errorMessage).append(System.lineSeparator());
        }
        return errorBuilder.toString();
    }
}

