/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.service;

import com.societegenerale.commons.plugin.Log;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaUnit;
import org.jboss.forge.roaster.model.source.JavaSource;

class JavaFileParser {
    JavaFileParser() {
    }

    JavaFile parse(Path javafilePath, Log logger) throws IOException {
        JavaUnit parsedJavaFile = Roaster.parseUnit((InputStream)Files.newInputStream(javafilePath, new OpenOption[0]));
        JavaSource myClass = (JavaSource)parsedJavaFile.getGoverningType();
        return new JavaFile(myClass.getPackage(), myClass.getName());
    }

    static class JavaFile {
        private final String packageString;
        private final String className;

        JavaFile(String packageString, String className) {
            this.packageString = packageString == null || packageString.isEmpty() ? null : packageString;
            this.className = className == null || className.isEmpty() ? null : className;
        }

        String getPackageString() {
            return this.packageString;
        }

        String getClassName() {
            return this.className;
        }
    }
}

