/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.societegenerale.commons.plugin.Log;
import com.societegenerale.commons.plugin.service.IllegalChecksConfigurationException;
import com.societegenerale.commons.plugin.utils.ReflectionUtils;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ArchRule;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class InvokableRules {
    private final Class<?> rulesLocation;
    private final Set<Field> archRuleFields;
    private final Set<Method> archRuleMethods;
    private final Log log;

    private InvokableRules(String rulesClassName, List<String> ruleChecks, Log log) {
        this.log = log;
        this.rulesLocation = ReflectionUtils.loadClassWithContextClassLoader(rulesClassName);
        Set<Field> allFieldsWhichAreArchRules = this.getAllFieldsWhichAreArchRules(this.rulesLocation.getDeclaredFields());
        Set<Method> allMethodsWhichAreArchRules = this.getAllMethodsWhichAreArchRules(this.rulesLocation.getDeclaredMethods());
        this.validateRuleChecks((Set<? extends Member>)Sets.union(allMethodsWhichAreArchRules, allFieldsWhichAreArchRules), ruleChecks);
        Predicate<String> isChosenCheck = ruleChecks.isEmpty() ? check -> true : ruleChecks::contains;
        this.archRuleFields = this.filterNames(allFieldsWhichAreArchRules, isChosenCheck);
        this.archRuleMethods = this.filterNames(allMethodsWhichAreArchRules, isChosenCheck);
        if (log.isInfoEnabled()) {
            this.logBuiltInvokableRules(rulesClassName);
        }
    }

    private void logBuiltInvokableRules(String rulesClassName) {
        this.log.info("just built " + rulesClassName + " : ");
        this.log.info(this.archRuleFields.size() + " field rules loaded ");
        this.archRuleFields.stream().forEach(a -> this.log.info(a.toString()));
        this.log.info(this.archRuleMethods.size() + " method rules loaded");
        this.archRuleMethods.stream().forEach(a -> this.log.info(a.toString()));
    }

    private void validateRuleChecks(Set<? extends Member> allFieldsAndMethods, Collection<String> ruleChecks) {
        Set allFieldAndMethodNames = allFieldsAndMethods.stream().map(Member::getName).collect(Collectors.toSet());
        Sets.SetView illegalChecks = Sets.difference((Set)ImmutableSet.copyOf(ruleChecks), allFieldAndMethodNames);
        if (!illegalChecks.isEmpty()) {
            throw new IllegalChecksConfigurationException(this.rulesLocation, (Set<String>)illegalChecks);
        }
    }

    private <M extends Member> Set<M> filterNames(Set<M> members, Predicate<String> namePredicate) {
        return members.stream().filter(member -> namePredicate.test(member.getName())).collect(Collectors.toSet());
    }

    private Set<Method> getAllMethodsWhichAreArchRules(Method[] methods) {
        return Arrays.stream(methods).filter(m -> m.getParameterCount() == 1 && JavaClasses.class.isAssignableFrom(m.getParameterTypes()[0])).collect(Collectors.toSet());
    }

    private Set<Field> getAllFieldsWhichAreArchRules(Field[] fields) {
        return Arrays.stream(fields).filter(f -> ArchRule.class.isAssignableFrom(f.getType())).collect(Collectors.toSet());
    }

    InvocationResult invokeOn(JavaClasses importedClasses) {
        Object instance = ReflectionUtils.newInstance(this.rulesLocation);
        if (this.log.isInfoEnabled()) {
            this.log.info("applying rules on " + importedClasses.size() + " classe(s). To see the details, enable debug logs");
            if (this.log.isDebugEnabled()) {
                importedClasses.stream().forEach(c -> this.log.debug(c.getName()));
            }
        }
        InvocationResult result = new InvocationResult();
        for (Method method : this.archRuleMethods) {
            this.checkForFailure(() -> ReflectionUtils.invoke(method, instance, importedClasses)).ifPresent(x$0 -> result.add((String)x$0));
        }
        for (Field field : this.archRuleFields) {
            ArchRule rule = (ArchRule)ReflectionUtils.getValue(field, instance);
            this.checkForFailure(() -> rule.check(importedClasses)).ifPresent(x$0 -> result.add((String)x$0));
        }
        return result;
    }

    private Optional<String> checkForFailure(Runnable runnable) {
        try {
            runnable.run();
            return Optional.empty();
        }
        catch (AssertionError | RuntimeException e) {
            return Optional.of(((Throwable)e).getMessage());
        }
    }

    static InvokableRules of(String rulesClassName, List<String> checks, Log log) {
        return new InvokableRules(rulesClassName, checks, log);
    }

    static class InvocationResult {
        private final List<String> violations = new ArrayList<String>();

        InvocationResult() {
        }

        private void add(String violationMessage) {
            this.violations.add(violationMessage);
        }

        String getMessage() {
            return this.violations.stream().collect(Collectors.joining(System.lineSeparator()));
        }
    }
}

