/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.service;

import com.societegenerale.commons.plugin.Log;
import com.societegenerale.commons.plugin.service.JavaFileParser;
import com.tngtech.archunit.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;

class ExcludedPathsPreProcessor
implements Serializable {
    private static final String FILE_TYPE_JAVA = ".java";
    static final String GENERATED_SOURCES = "generated-sources";
    static final String PACKAGE_INFO_JAVA = "package-info.java";

    ExcludedPathsPreProcessor() {
    }

    public Set<String> processExcludedPaths(@Nonnull Log logger, String projectBuildDir, Collection<String> excludedPaths) {
        HashSet<String> result;
        HashSet<String> hashSet = result = excludedPaths != null ? new HashSet<String>(excludedPaths) : new HashSet();
        if (excludedPaths == null) {
            return result;
        }
        logger.debug("projectBuildDir: " + projectBuildDir);
        String targetDir = projectBuildDir != null ? projectBuildDir.trim() : "";
        for (String pathAsString : excludedPaths) {
            Path path = this.convertToPath(logger, targetDir, pathAsString.trim());
            Set<Path> javaFiles = this.findJavaFiles(path, logger);
            Set<String> classNames = this.determineClassNames(javaFiles, logger);
            result.addAll(classNames);
        }
        return result;
    }

    @VisibleForTesting
    Set<Path> findJavaFiles(Path path, @Nonnull Log logger) {
        Set<Path> files = new HashSet<Path>();
        try {
            if (path != null) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    files = Files.find(path, Integer.MAX_VALUE, (p, basicFileAttributes) -> this.isJavaFile(p.toString()), new FileVisitOption[0]).collect(Collectors.toSet());
                } else if (this.isJavaFile(path.toString())) {
                    files.add(path);
                }
            }
        }
        catch (IOException e) {
            logger.warn("unable to collect java files in path: " + path, e);
        }
        return files;
    }

    @VisibleForTesting
    boolean isJavaFile(String pathString) {
        String path = pathString != null ? pathString.toLowerCase().trim() : "";
        return !path.endsWith(PACKAGE_INFO_JAVA) && path.endsWith(FILE_TYPE_JAVA);
    }

    @Nullable
    @VisibleForTesting
    Path convertToPath(@Nonnull Log logger, String projectBuildDir, @Nonnull String pathAsString) throws InvalidPathException {
        Path result;
        try {
            result = Paths.get(pathAsString, new String[0]);
            if (Files.exists(result, new LinkOption[0])) {
                return result;
            }
        }
        catch (InvalidPathException e) {
            logger.debug("invalid path: " + pathAsString, e);
        }
        try {
            String concatPath = FilenameUtils.concat((String)projectBuildDir, (String)pathAsString);
            logger.debug("concatPath: " + concatPath);
            result = Paths.get(concatPath, new String[0]);
            if (!Files.exists(result, new LinkOption[0])) {
                logger.warn("invalid exclusion path: " + concatPath);
                result = null;
            }
        }
        catch (InvalidPathException e) {
            logger.warn("invalid path: " + pathAsString, e);
            result = null;
        }
        return result;
    }

    @VisibleForTesting
    Set<String> determineClassNames(Set<Path> javaFilePaths, Log logger) {
        JavaFileParser fileParser = new JavaFileParser();
        HashSet<String> packageWithClassNames = new HashSet<String>();
        for (Path path : javaFilePaths) {
            try {
                JavaFileParser.JavaFile file = fileParser.parse(path, logger);
                if (file.getClassName() == null) continue;
                String packageWithClassName = file.getPackageString() != null ? file.getPackageString() + "." + file.getClassName() : file.getClassName();
                packageWithClassNames.add(packageWithClassName);
            }
            catch (IOException e) {
                logger.warn("unable to read file: " + path);
            }
        }
        return packageWithClassNames;
    }
}

