/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Test;

public class TestMethodsNamingRuleTest
implements ArchRuleTest {
    private static final String TEST_METHODS_NAMING_REGEX = "^(test|should)[A-Z][a-zA-Z0-9]*$";
    private static final Pattern TEST_METHODS_NAMING_PATTERN = Pattern.compile("^(test|should)[A-Z][a-zA-Z0-9]*$");
    private static Matcher matcher;
    public static final String TEST_METHODS_VIOLATION_MESSAGE = "Test methods should comply with a naming convention. Method name has to start with prefixes \"test\" or \"should\" ";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areAnnotatedWith(Test.class)).should(this.respectNamingConvention()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getTestClassesPath(), packagePath, excludedPaths));
    }

    private ArchCondition<JavaMethod> respectNamingConvention() {
        return new ArchCondition<JavaMethod>("comply with a naming convention", new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                if (this.isInCorrect(method)) {
                    events.add(SimpleConditionEvent.violated((Object)method, (String)("Test methods should comply with a naming convention. Method name has to start with prefixes \"test\" or \"should\"  - class: " + method.getClass().getSimpleName() + " - method: " + method.getName())));
                }
            }

            private boolean isInCorrect(JavaMethod javaMethod) {
                matcher = TEST_METHODS_NAMING_PATTERN.matcher(javaMethod.getName());
                return !matcher.matches();
            }
        };
    }
}

