/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Test;

public class TestClassesNamingRuleTest
implements ArchRuleTest {
    private static final String TEST_CLASSES_NAMING_REGEX = "^((Test|IT)[a-zA-Z0-9]+|[A-Z][a-zA-Z0-9]*(Test|Tests|IT|TestCase|ITCase))$";
    private static final Pattern TEST_CLASSES_NAMING_PATTERN = Pattern.compile("^((Test|IT)[a-zA-Z0-9]+|[A-Z][a-zA-Z0-9]*(Test|Tests|IT|TestCase|ITCase))$");
    public static final String TEST_CLASS_VIOLATION_MESSAGE = "Test classes should comply with a naming convention";
    private final DescribedPredicate<JavaClass> haveAMethodAnnotatedWithTest = new DescribedPredicate<JavaClass>("have a method annotated with @Test", new Object[0]){

        public boolean test(JavaClass input) {
            return this.isTestClass(input);
        }

        private boolean isTestClass(JavaClass input) {
            Class<?>[] innerClasses = input.reflect().getDeclaredClasses();
            if (innerClasses.length == 0) {
                return this.isThereAtLeastOneMethodAnnotedWithTest(input);
            }
            JavaClasses javaInnerClasses = new ClassFileImporter().importClasses(Arrays.asList(innerClasses));
            Set testClasses = javaInnerClasses.stream().filter(this::isThereAtLeastOneMethodAnnotedWithTest).collect(Collectors.toSet());
            return !testClasses.isEmpty();
        }

        private boolean isThereAtLeastOneMethodAnnotedWithTest(JavaClass javaClass) {
            return !javaClass.getMethods().stream().filter(this::isAnnotedWithTest).collect(Collectors.toSet()).isEmpty();
        }

        private boolean isAnnotedWithTest(JavaMethod method) {
            return method.isAnnotatedWith(Test.class);
        }
    };

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.classes().that(this.haveAMethodAnnotatedWithTest).should(this.respectNamingConvention()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getTestClassesPath(), packagePath, excludedPaths));
    }

    private ArchCondition<JavaClass> respectNamingConvention() {
        return new ArchCondition<JavaClass>("comply with a naming convention", new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                if (this.isInCorrect(item)) {
                    events.add(SimpleConditionEvent.violated((Object)item, (String)("Test classes should comply with a naming convention - class: " + item.getName())));
                }
            }

            private boolean isInCorrect(JavaClass javaClass) {
                return !TEST_CLASSES_NAMING_PATTERN.matcher(javaClass.getSimpleName()).matches();
            }
        };
    }
}

