/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import java.util.Collection;
import java.util.regex.Pattern;

public class StringFieldsThatAreActuallyDatesRuleTest
implements ArchRuleTest {
    private static final Pattern STRING_FIELDS_THAT_ARE_ACTUALLY_DATES_PATTERN = Pattern.compile(".*Date$");
    private DescribedPredicate<JavaField> endWithDate = new DescribedPredicate<JavaField>("are finished by \"Date\"", new Object[0]){

        public boolean test(JavaField field) {
            return STRING_FIELDS_THAT_ARE_ACTUALLY_DATES_PATTERN.matcher(field.getName()).matches();
        }
    };

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ((GivenFieldsConjunction)ArchRuleDefinition.fields().that().haveRawType(String.class)).and(this.endWithDate).should(this.beDates()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }

    private ArchCondition<JavaField> beDates() {
        return new ArchCondition<JavaField>("be Dates", new Object[0]){

            public void check(JavaField field, ConditionEvents events) {
                events.add(SimpleConditionEvent.violated((Object)field, (String)("field \"" + field.getName() + "\" is a String, but it seems to be a Date. If it really is a Date, please change its type accordingly. Strong typing helps write more meaningful code. - class: " + field.getOwner().getName())));
            }
        };
    }
}

