/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.junit.Ignore;
import org.junit.jupiter.api.Disabled;

public class NoTestIgnoreWithoutCommentRuleTest
implements ArchRuleTest {
    protected static final String NO_JUNIT_IGNORE_WITHOUT_COMMENT_VIOLATION_MESSAGE = "Tests shouldn't been ignored without providing a comment explaining why";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.classes().should(NoTestIgnoreWithoutCommentRuleTest.notBeIgnoredWithoutAComment()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getTestClassesPath(), packagePath, excludedPaths));
    }

    public static ArchCondition<JavaClass> notBeIgnoredWithoutAComment() {
        return new ArchCondition<JavaClass>(NO_JUNIT_IGNORE_WITHOUT_COMMENT_VIOLATION_MESSAGE, new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                String violationMessageAtClassLevel = item.getName() + ", at class level";
                this.addViolationEvent(this.buildViolationIfAnnotationWithNoValueFound((HasAnnotations)item, Ignore.class, violationMessageAtClassLevel), events);
                this.addViolationEvent(this.buildViolationIfAnnotationWithNoValueFound((HasAnnotations)item, Disabled.class, violationMessageAtClassLevel), events);
                for (JavaMethod method : item.getMethods()) {
                    String violationMessageAtMethodLevel = item.getName() + " - " + method.getName() + ", at method level";
                    this.addViolationEvent(this.buildViolationIfAnnotationWithNoValueFound((HasAnnotations)method, Ignore.class, violationMessageAtMethodLevel), events);
                    this.addViolationEvent(this.buildViolationIfAnnotationWithNoValueFound((HasAnnotations)method, Disabled.class, violationMessageAtMethodLevel), events);
                }
            }

            private void addViolationEvent(Optional<ConditionEvent> violation, ConditionEvents events) {
                violation.ifPresent(arg_0 -> ((ConditionEvents)events).add(arg_0));
            }

            private Optional<ConditionEvent> buildViolationIfAnnotationWithNoValueFound(HasAnnotations item, Class annotation, String violationMessage) {
                try {
                    if (this.getAnnotationValue(item, annotation).isEmpty()) {
                        return Optional.of(SimpleConditionEvent.violated((Object)item, (String)violationMessage));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
                return Optional.empty();
            }

            private String getAnnotationValue(HasAnnotations annotatedObj, Class annotation) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
                Annotation ann = annotatedObj.getAnnotationOfType(annotation);
                Method valueMethod = ann.getClass().getDeclaredMethod("value", new Class[0]);
                return (String)valueMethod.invoke((Object)ann, new Object[0]);
            }
        };
    }
}

