/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.util.Collection;

public class NoPrefixForInterfacesRuleTest
implements ArchRuleTest {
    protected static final String NO_PREFIX_INTERFACE_VIOLATION_MESSAGE = " : Interfaces shouldn't be prefixed with \"I\" - caller doesn't need to know it's an interface + this is a .Net convention";
    private static final Character upperCaseI = Character.valueOf('I');

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ((GivenClassesConjunction)ArchRuleDefinition.classes().that().areInterfaces()).should(NoPrefixForInterfacesRuleTest.notBePrefixed()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }

    public static ArchCondition<JavaClass> notBePrefixed() {
        return new ArchCondition<JavaClass>("not be prefixed with I - this is a .Net convention.", new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                Character firstCharacter = Character.valueOf(item.getSimpleName().charAt(0));
                char secondCharacter = item.getSimpleName().charAt(1);
                if (firstCharacter.equals(upperCaseI) && Character.isUpperCase(secondCharacter)) {
                    events.add(SimpleConditionEvent.violated((Object)item, (String)(item.getName() + NoPrefixForInterfacesRuleTest.NO_PREFIX_INTERFACE_VIOLATION_MESSAGE)));
                }
            }
        };
    }
}

