/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Collection;
import java.util.Optional;
import org.junit.runner.RunWith;

public class NoPowerMockRuleTest
implements ArchRuleTest {
    private static final String POWER_MOCK_RUNNER_CLASS_NAME = "PowerMockRunner";
    protected static final String POWER_MOCK_VIOLATION_MESSAGE = "Favor Mockito and proper dependency injection - ";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.classes().should(NoPowerMockRuleTest.notUsePowerMock()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getTestClassesPath(), packagePath, excludedPaths));
    }

    public static ArchCondition<JavaClass> notUsePowerMock() {
        return new ArchCondition<JavaClass>("not use Powermock", new Object[0]){

            public void check(JavaClass testClass, ConditionEvents events) {
                try {
                    Optional runWithAnnotation = testClass.tryGetAnnotationOfType(RunWith.class);
                    if (runWithAnnotation.isPresent() && ((RunWith)runWithAnnotation.get()).toString().contains(NoPowerMockRuleTest.POWER_MOCK_RUNNER_CLASS_NAME)) {
                        events.add(SimpleConditionEvent.violated((Object)testClass, (String)(NoPowerMockRuleTest.POWER_MOCK_VIOLATION_MESSAGE + testClass.getName())));
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
    }
}

