/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Collection;

public class NoJunitAssertRuleTest
implements ArchRuleTest {
    protected static final String NO_JUNIT_ASSERT_DESCRIPTION = "not use Junit assertions";
    private static final String JUNIT4_ASSERT_PACKAGE_NAME = "org.junit.Assert";
    private static final String JUNIT5_ASSERT_PACKAGE_NAME = "org.junit.jupiter.api.Assertions";
    private static final String PACKAGE_SEPARATOR = ".";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.classes().should(NoJunitAssertRuleTest.notUseJunitAssertRule()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getTestClassesPath(), packagePath, excludedPaths));
    }

    protected static ArchCondition<JavaClass> notUseJunitAssertRule() {
        return new ArchCondition<JavaClass>(NO_JUNIT_ASSERT_DESCRIPTION, new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                item.getMethodCallsFromSelf().stream().filter(methodCall -> NoJunitAssertRuleTest.isJunitAssert(((AccessTarget.MethodCallTarget)methodCall.getTarget()).getOwner())).forEach(junitAssertCall -> events.add(SimpleConditionEvent.violated((Object)junitAssertCall, (String)("Favor AssertJ assertions over Junit's - " + junitAssertCall.getDescription()))));
            }
        };
    }

    static boolean isJunitAssert(JavaClass javaClass) {
        String packageNameToCheck = javaClass.getPackageName() + PACKAGE_SEPARATOR + javaClass.getSimpleName();
        return JUNIT4_ASSERT_PACKAGE_NAME.equals(packageNameToCheck) || JUNIT5_ASSERT_PACKAGE_NAME.equals(packageNameToCheck);
    }
}

