/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class NoJodaTimeRuleTest
implements ArchRuleTest {
    private static final String JODATIME_PACKAGE_PREFIX = "org.joda";
    protected static final String NO_JODA_VIOLATION_MESSAGE = "Use Java8 Date API instead of Joda library";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.classes().should(NoJodaTimeRuleTest.notUseJodaTime()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }

    protected static ArchCondition<JavaClass> notUseJodaTime() {
        return new ArchCondition<JavaClass>("not use Joda time ", new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                List classesWithJodaTimeFields = item.getAllFields().stream().filter(this::isJodaTimeField).collect(Collectors.toList());
                for (JavaField field : classesWithJodaTimeFields) {
                    events.add(SimpleConditionEvent.violated((Object)field, (String)("Use Java8 Date API instead of Joda library - class: " + field.getOwner().getName() + " - field name: " + field.getName())));
                }
                List methodsUsingJodaTimeInternally = item.getCodeUnits().stream().filter(codeUnit -> codeUnit instanceof JavaMethod).flatMap(method -> method.getMethodCallsFromSelf().stream()).filter(method -> method instanceof JavaMethodCall).filter(this::isMethodUsingJodaTimeInternally).collect(Collectors.toList());
                for (JavaMethodCall methodCall : methodsUsingJodaTimeInternally) {
                    events.add(SimpleConditionEvent.violated((Object)methodCall.getOriginOwner(), (String)("Use Java8 Date API instead of Joda library - class: " + methodCall.getOriginOwner().getName() + " - method: " + ((AccessTarget.MethodCallTarget)methodCall.getTarget()).getOwner().getSimpleName() + "." + ((AccessTarget.MethodCallTarget)methodCall.getTarget()).getName() + " - line: " + methodCall.getLineNumber())));
                }
            }

            private boolean isJodaTimeField(JavaField field) {
                return field.getRawType().getName().startsWith(NoJodaTimeRuleTest.JODATIME_PACKAGE_PREFIX);
            }

            private boolean isMethodUsingJodaTimeInternally(JavaMethodCall javaMethodCall) {
                return ((AccessTarget.MethodCallTarget)javaMethodCall.getTarget()).getFullName().startsWith(NoJodaTimeRuleTest.JODATIME_PACKAGE_PREFIX);
            }
        };
    }
}

