/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Collection;

public class NoJavaUtilDateRuleTest
implements ArchRuleTest {
    private static final String JAVA_UTIL_DATE_PACKAGE_PREFIX = "java.util.Date";
    protected static final String NO_JAVA_UTIL_DATE_VIOLATION_MESSAGE = "Use Java8 java.time or java.util.GregorianCalendar or java.text.DateFormat  to parse and format dates instead of java.util.Date library because they  support internationalization better";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.classes().should(NoJavaUtilDateRuleTest.notUseJavaUtilDate()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }

    protected static ArchCondition<JavaClass> notUseJavaUtilDate() {
        return new ArchCondition<JavaClass>("not use Java Util Date", new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                item.getAllFields().stream().filter(this::isJavaUtilDateField).forEach(field -> events.add(SimpleConditionEvent.violated((Object)field, (String)("Use Java8 java.time or java.util.GregorianCalendar or java.text.DateFormat  to parse and format dates instead of java.util.Date library because they  support internationalization better - class: " + field.getOwner().getName()))));
            }

            private boolean isJavaUtilDateField(JavaField field) {
                return field.getRawType().getName().startsWith(NoJavaUtilDateRuleTest.JAVA_UTIL_DATE_PACKAGE_PREFIX);
            }
        };
    }
}

