/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Collection;
import javax.inject.Inject;

public class NoInjectedFieldTest
implements ArchRuleTest {
    protected static final String NO_INJECTED_FIELD_MESSAGE = "Favor constructor injection and avoid field injection - ";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.fields().should(NoInjectedFieldTest.notBeInjected()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }

    protected static ArchCondition<JavaField> notBeInjected() {
        return new ArchCondition<JavaField>("not be injected", new Object[0]){

            public void check(JavaField javaField, ConditionEvents events) {
                if (javaField.isAnnotatedWith(Inject.class)) {
                    events.add(SimpleConditionEvent.violated((Object)javaField, (String)("Favor constructor injection and avoid field injection -  - class: " + javaField.getOwner().getName() + " - field name: " + javaField.getName())));
                }
            }
        };
    }
}

