/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.util.Collection;

public class NoAutowiredFieldTest
implements ArchRuleTest {
    protected static final String NO_AUTOWIRED_FIELD_MESSAGE = "Favor constructor injection and avoid autowiring fields - ";

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ArchRuleDefinition.fields().should(NoAutowiredFieldTest.notBeAutowired()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }

    protected static ArchCondition<JavaField> notBeAutowired() {
        return new ArchCondition<JavaField>("not be autowired", new Object[0]){

            public void check(JavaField javaField, ConditionEvents events) {
                if (javaField.isAnnotatedWith("org.springframework.beans.factory.annotation.Autowired")) {
                    events.add(SimpleConditionEvent.violated((Object)javaField, (String)("Favor constructor injection and avoid autowiring fields -  - class: " + javaField.getOwner().getName() + " - field name: " + javaField.getName())));
                }
            }
        };
    }
}

