/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.Log;
import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HexagonalArchitectureTest
implements ArchRuleTest {
    protected static final String WHEN_FOLLOWING_HEXAGONAL_ARCHITECTURE = "When following hexagonal architecture, ";
    private static final String DOMAIN = "..domain..";
    private Log log;
    private static String[] allowedPackageInDomain = new String[]{"..domain..", "java..", "javax.validation..", "org.slf4j..", "lombok..", "org.apache.commons.."};
    private final String FORBIDDEN_SUFFIX_DTO = ".*Dto$";
    private final String FORBIDDEN_SUFFIX_VO = ".*Vo$";
    private static List<String> allowedPackageInDomainPrefix = Arrays.asList(allowedPackageInDomain).stream().map(p -> p.replace("..", "")).collect(Collectors.toList());
    private DescribedPredicate<JavaAnnotation> invalidAnnotations = new DescribedPredicate<JavaAnnotation>("invalid annotations, that don't belong to authorized packages", new Object[0]){

        public boolean test(JavaAnnotation annotation) {
            String annotationName = annotation.getRawType().getPackage().getName();
            HexagonalArchitectureTest.this.log.info("testing " + annotationName + "...");
            Optional<String> allowedPackagePrefixThatMatched = allowedPackageInDomainPrefix.stream().filter(allowedPackagePrefix -> annotationName.startsWith((String)allowedPackagePrefix)).findFirst();
            if (allowedPackagePrefixThatMatched.isPresent()) {
                HexagonalArchitectureTest.this.log.info(annotationName + " starts with " + allowedPackagePrefixThatMatched.get() + ", which is an allowed prefix");
                return false;
            }
            HexagonalArchitectureTest.this.log.warn(annotationName + " starts with none of the allowed prefixes");
            return true;
        }
    };

    public HexagonalArchitectureTest(Log log) {
        this.log = log;
    }

    protected static ArchCondition<JavaClass> notHaveAnameEndingBy_ignoringCase(final String forbiddenSuffixRegexp) {
        return new ArchCondition<JavaClass>("not have a name with that suffix", new Object[0]){
            Pattern pattern;
            {
                super(description, args);
                this.pattern = Pattern.compile(forbiddenSuffixRegexp, 2);
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (this.pattern.matcher(javaClass.getSimpleName()).matches()) {
                    events.add(SimpleConditionEvent.violated((Object)javaClass, (String)("class matched pattern " + forbiddenSuffixRegexp + " (ignoring case) - class: " + javaClass.getName())));
                }
            }
        };
    }

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ((GivenClassesConjunction)ArchRuleDefinition.classes().that().resideInAPackage(DOMAIN)).should(HexagonalArchitectureTest.notHaveAnameEndingBy_ignoringCase(".*Dto$")).andShould(HexagonalArchitectureTest.notHaveAnameEndingBy_ignoringCase(".*Vo$")).because("When following hexagonal architecture, DTO / VO classes shouldn't be located in domain, as they are not business oriented").allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
        ((ClassesShouldConjunction)((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAPackage(DOMAIN)).should().accessClassesThat().resideInAPackage("..infrastructure..")).orShould().accessClassesThat().resideInAPackage("..config..")).because("When following hexagonal architecture, domain classes should not know about infrastructure or config code").allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
        ((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAPackage("..infrastructure..")).should().accessClassesThat().resideInAPackage("..config..")).because("When following hexagonal architecture, infrastructure classes should not know about config code").allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
        ((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().resideInAPackage(DOMAIN)).should().onlyAccessClassesThat().resideInAnyPackage(allowedPackageInDomain)).andShould().notBeAnnotatedWith(this.invalidAnnotations).because("When following hexagonal architecture, domain classes should use only a limited set of core libraries, ie no external framework").allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }
}

