/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import java.util.Collection;
import javax.annotation.Nonnull;

public class DontReturnNullCollectionTest
implements ArchRuleTest {
    protected static final String NO_NULL_COLLECTION_MESSAGE = "we don't want callers to perform null check every time. Return an empty collection, not null. Please annotate the method with " + Nonnull.class.getCanonicalName();
    DescribedPredicate<JavaMethod> areNotLambdas = new DescribedPredicate<JavaMethod>("are not lambda", new Object[0]){

        public boolean test(JavaMethod input) {
            return !input.getName().contains("lambda$new");
        }
    };
    DescribedPredicate<JavaMethod> returnCollections = new DescribedPredicate<JavaMethod>("return collections", new Object[0]){

        public boolean test(JavaMethod input) {
            JavaClass returnedJavaClass = input.getReturnType().toErasure();
            return returnedJavaClass.getAllRawInterfaces().stream().anyMatch(implementedInterface -> implementedInterface.isAssignableTo(Collection.class));
        }
    };

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        JavaClasses classesToCheck = ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths);
        ArchRule rule = ((MethodsShouldConjunction)ArchRuleDefinition.methods().that(this.returnCollections).and(this.areNotLambdas).should().beAnnotatedWith(Nonnull.class)).because(NO_NULL_COLLECTION_MESSAGE).allowEmptyShould(true);
        rule.check(classesToCheck);
    }
}

