/*
 * Decompiled with CFR 0.152.
 */
package com.societegenerale.commons.plugin.rules;

import com.societegenerale.commons.plugin.rules.ArchRuleTest;
import com.societegenerale.commons.plugin.service.ScopePathProvider;
import com.societegenerale.commons.plugin.utils.ArchUtils;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstantsAndStaticNonFinalFieldsNamesRuleTest
implements ArchRuleTest {
    private static final String CONSTANTS_REGEX = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private static final String STATIC_NON_FINAL_FIELDS_REGEX = "^[a-z][a-zA-Z0-9]*$";
    private static final Pattern CONSTANTS_PATTERN = Pattern.compile("^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$");
    private static final Pattern STATIC_NON_FINAL_FIELDS_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    private static Matcher matcher;
    public static final String CONSTANTS_VIOLATION_MESSAGE = "Constants have to be written in uppercase. It's possible to add underscore but not at the beginning or the end of the name.";
    public static final String STATIC_NON_FINAL_FIELDS_VIOLATION_MESSAGE = "Static non-final fields should be in upperCase and/or use underscore";
    public static final String ENUM_CONSTANTS_VIOLATION_MESSAGE = "Enum constants have to be written in uppercase. It's possible to add underscore but not at the beginning or the end of the name.";
    DescribedPredicate<JavaField> areNotSerialVersionUID = new DescribedPredicate<JavaField>("are not serialVersionUID", new Object[0]){

        public boolean test(JavaField input) {
            return !input.getName().equals("serialVersionUID");
        }
    };

    @Override
    public void execute(String packagePath, ScopePathProvider scopePathProvider, Collection<String> excludedPaths) {
        ((GivenFieldsConjunction)((GivenFieldsConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areDeclaredInClassesThat().areNotEnums()).and().areStatic()).and().areFinal()).and(this.areNotSerialVersionUID).should(ConstantsAndStaticNonFinalFieldsNamesRuleTest.beInUpperCaseAndUseUnderscore()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
        ((GivenFieldsConjunction)((GivenFieldsConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areDeclaredInClassesThat().areNotEnums()).and().areStatic()).and().areNotFinal()).should(ConstantsAndStaticNonFinalFieldsNamesRuleTest.notBeInUpperCaseAndUseUnderscore()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
        ((GivenClassesConjunction)ArchRuleDefinition.classes().that().areEnums()).should(ConstantsAndStaticNonFinalFieldsNamesRuleTest.haveConstantsInUpperCaseAndUseUnderscore()).allowEmptyShould(true).check(ArchUtils.importAllClassesInPackage(scopePathProvider.getMainClassesPath(), packagePath, excludedPaths));
    }

    protected static ArchCondition<JavaField> beInUpperCaseAndUseUnderscore() {
        return new ArchCondition<JavaField>("be In UpperCase And Use Underscore", new Object[0]){

            public void check(JavaField javaField, ConditionEvents events) {
                if (this.isInCorrect(javaField)) {
                    events.add(SimpleConditionEvent.violated((Object)javaField, (String)("Constants have to be written in uppercase. It's possible to add underscore but not at the beginning or the end of the name. - class: " + javaField.getOwner().getName() + " - field name: " + javaField.getName())));
                }
            }

            private boolean isInCorrect(JavaField field) {
                matcher = CONSTANTS_PATTERN.matcher(field.getName());
                return !matcher.matches();
            }
        };
    }

    protected static ArchCondition<JavaField> notBeInUpperCaseAndUseUnderscore() {
        return new ArchCondition<JavaField>("not Be In UpperCase And Use Underscore", new Object[0]){

            public void check(JavaField javaField, ConditionEvents events) {
                if (this.isIncorrect(javaField)) {
                    events.add(SimpleConditionEvent.violated((Object)javaField, (String)("Static non-final fields should be in upperCase and/or use underscore - class: " + javaField.getOwner().getName() + " - field name: " + javaField.getName())));
                }
            }

            private boolean isIncorrect(JavaField field) {
                matcher = STATIC_NON_FINAL_FIELDS_PATTERN.matcher(field.getName());
                return !matcher.matches();
            }
        };
    }

    protected static ArchCondition<JavaClass> haveConstantsInUpperCaseAndUseUnderscore() {
        return new ArchCondition<JavaClass>("have constants in UpperCase And Use Underscore", new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                item.getEnumConstants().stream().filter(this::isInCorrectEnums).forEach(field -> events.add(SimpleConditionEvent.violated((Object)field, (String)("Enum constants have to be written in uppercase. It's possible to add underscore but not at the beginning or the end of the name. - class: " + field.getDeclaringClass().getName() + " - field name: " + field.name()))));
            }

            private boolean isInCorrectEnums(JavaEnumConstant enumConstant) {
                matcher = CONSTANTS_PATTERN.matcher(enumConstant.name());
                return !matcher.matches();
            }
        };
    }
}

