/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.view;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.error.SocializeErrorHandler;
import com.socialize.log.SocializeLogger;
import com.socialize.view.SocializeView;

public abstract class BaseView
extends LinearLayout
implements SocializeView {
    private SocializeErrorHandler errorHandler;
    private int loadCount = 0;
    private int lastId = 0;
    private boolean rendered = false;
    private Toast toast;

    public BaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseView(Context context) {
        super(context);
    }

    public void showErrorToast(Context context, Exception e) {
        if (this.toast != null) {
            this.toast.cancel();
        }
        this.toast = Toast.makeText((Context)context, (CharSequence)("Error: " + e.getMessage()), (int)1);
        this.toast.show();
    }

    @Override
    public void showError(Context context, Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(context, e);
        } else {
            SocializeLogger.e("", e);
        }
    }

    public SocializeErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SocializeErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    @Override
    public Activity getActivity() {
        Context context = this.getContext();
        if (context instanceof Activity) {
            return (Activity)context;
        }
        return null;
    }

    protected void onWindowVisibilityChanged(int visibility) {
        block8: {
            super.onWindowVisibilityChanged(visibility);
            if (!this.isInEditMode()) {
                if (visibility == 0) {
                    try {
                        if (!this.checkLoaded()) {
                            this.onViewLoad();
                            break block8;
                        }
                        this.onViewUpdate();
                    }
                    catch (Exception e) {
                        this.onViewError(e);
                    }
                } else {
                    this.rendered = false;
                }
            } else {
                View editView = this.getEditModeView();
                if (editView != null) {
                    this.addView(editView);
                }
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onRender(w, h);
    }

    protected void onRender(int w, int h) {
        if (!this.rendered) {
            this.rendered = true;
            try {
                this.onViewRendered(w, h);
            }
            catch (Exception e) {
                this.onViewError(e);
            }
        }
    }

    protected void incrementLoaded() {
        ++this.loadCount;
    }

    protected boolean checkLoaded() {
        boolean loaded = this.loadCount > 0;
        this.incrementLoaded();
        return loaded;
    }

    protected View getEditModeView() {
        return null;
    }

    public void assignId(View parent) {
        this.setId(this.getNextViewId(parent));
    }

    @Override
    public void onViewUpdate() {
    }

    @Override
    public void onViewLoad() {
    }

    @Override
    public void onViewError(Exception e) {
        this.setVisibility(8);
    }

    @Override
    public void onViewRendered(int width, int height) {
    }

    protected View getParentView() {
        ViewParent parent = this.getParent();
        if (parent instanceof View) {
            return (View)parent;
        }
        return this;
    }

    protected int getNextViewId(View parent) {
        ViewGroup group;
        int childCount;
        if (parent instanceof ViewGroup && (childCount = (group = (ViewGroup)parent).getChildCount()) > 0) {
            int id = 0;
            for (int i = 0; i < childCount; ++i) {
                View child = group.getChildAt(i);
                int childId = child.getId();
                if (childId <= id) continue;
                id = childId;
            }
            while (id < this.lastId) {
                ++id;
            }
            this.lastId = id + 1;
            return this.lastId;
        }
        return ++this.lastId;
    }
}

