/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import com.socialize.log.SocializeLogger;
import java.io.InputStream;

public class SafeBitmapDrawable
extends BitmapDrawable {
    public SafeBitmapDrawable(InputStream is) {
        super(is);
    }

    public SafeBitmapDrawable() {
    }

    public SafeBitmapDrawable(Bitmap bitmap) {
        super(bitmap);
    }

    public SafeBitmapDrawable(Resources res, Bitmap bitmap) {
        super(res, bitmap);
    }

    public void draw(Canvas canvas) {
        if (!this.isRecycled()) {
            try {
                super.draw(canvas);
            }
            catch (Throwable e) {
                SocializeLogger.w("Bitmap was recycled");
            }
        } else {
            SocializeLogger.w("Bitmap was recycled");
        }
    }

    public boolean isRecycled() {
        Bitmap bmp = this.getBitmap();
        return bmp == null || bmp.isRecycled();
    }

    public void recycle() {
        Bitmap bmp = this.getBitmap();
        if (bmp != null) {
            bmp.recycle();
        }
    }
}

