/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import com.socialize.log.SocializeLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    private static final int IO_BUFFER_SIZE = 4096;
    private SocializeLogger logger;

    public String readSafe(InputStream in) {
        try {
            return this.read(in);
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error("", (Throwable)e);
            } else {
                SocializeLogger.e(e.getMessage(), e);
            }
            return "";
        }
    }

    public byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.pipe(in, out, 4096);
        return out.toByteArray();
    }

    public String read(InputStream in) throws IOException {
        return new String(this.readBytes(in), "UTF-8");
    }

    public long pipe(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int read = 0;
        long total = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((read = in.read(buffer)) >= 0) {
            total += (long)read;
            out.write(buffer, 0, read);
        }
        out.flush();
        return total;
    }

    public SocializeLogger getLogger() {
        return this.logger;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

