/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.auth.facebook.FacebookActivity;
import com.socialize.config.SocializeConfig;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.SocializeLaunchActivity;
import com.socialize.ui.action.ActionDetailActivity;
import com.socialize.ui.comment.CommentActivity;
import com.socialize.ui.profile.ProfileActivity;
import com.socialize.util.AppUtils;
import com.socialize.util.StringUtils;
import java.util.List;
import java.util.Locale;

public class DefaultAppUtils
implements AppUtils {
    private String packageName;
    private String appName;
    private String userAgent;
    private String country;
    private String carrier = "unknown";
    private String networkType = "unknown";
    private SocializeLogger logger;
    private SocializeConfig config;
    private boolean locationAvailable = false;
    private boolean locationAssessed = false;
    private boolean notificationsAvailable = false;
    private boolean notificationsAssessed = false;
    private String lastNotificationWarning = null;

    public void init(Context context) {
        this.packageName = context.getPackageName();
        try {
            PackageManager pkgManager = context.getPackageManager();
            this.appName = pkgManager.getApplicationLabel(pkgManager.getApplicationInfo(this.packageName, 0)).toString();
        }
        catch (Exception e) {
            String msg = "Failed to lookup application label.  Make sure this is specified in your AndroidManifest.xml";
            if (this.logger != null) {
                this.logger.error(msg, (Throwable)e);
            }
            SocializeLogger.e(msg, e);
        }
        if (StringUtils.isEmpty(this.appName)) {
            this.appName = this.packageName;
        }
        if (StringUtils.isEmpty(this.appName)) {
            this.appName = "A Socialize enabled app";
        }
        try {
            if (this.hasPermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
                this.country = manager.getNetworkCountryIso();
                this.carrier = manager.getNetworkOperatorName();
                if (StringUtils.isEmpty(this.carrier)) {
                    this.carrier = "unknown";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty(this.country)) {
            this.country = Locale.getDefault().getCountry();
        }
    }

    @Override
    public void onResume(Context context) {
        this.determineNetworkType(context);
    }

    private void determineNetworkType(Context context) {
        try {
            if (this.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo mWifi = connManager.getNetworkInfo(1);
                this.networkType = mWifi != null && mWifi.isConnected() ? "wifi" : "cell";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getAppStoreAbbreviation(String appStore) {
        if (appStore != null && appStore.equalsIgnoreCase("amazon")) {
            return "amz";
        }
        return null;
    }

    @Override
    public boolean isActivityAvailable(Context context, String activityClassName) {
        try {
            Class<?> activityClass = Class.forName(activityClassName);
            return this.isActivityAvailable(context, activityClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public boolean isActivityAvailable(Context context, Class<?> activity) {
        Intent intent = new Intent(context, activity);
        return this.isIntentAvailable(context, intent);
    }

    @Override
    public boolean isIntentAvailable(Context context, String action) {
        Intent intent = new Intent(action);
        return this.isIntentAvailable(context, intent);
    }

    @Override
    public boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.queryIntentActivities(intent, 65536).size() > 0;
    }

    @Override
    public boolean isServiceAvailable(Context context, Class<?> cls) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        return packageManager.queryIntentServices(intent = new Intent(context, cls), 65536).size() > 0;
    }

    @Override
    public ActivityInfo getActivityInfo(Context context, Class<?> cls) {
        try {
            PackageManager packageManager = context.getPackageManager();
            return packageManager.getActivityInfo(new ComponentName(context, cls), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            if (this.logger != null) {
                this.logger.error("Failed to locate info for activity [" + cls.getName() + "]", (Throwable)e);
            } else {
                SocializeLogger.e(e.getMessage(), e);
            }
            return null;
        }
    }

    @Override
    public boolean isReceiverAvailable(Context context, Class<?> cls) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        return packageManager.queryBroadcastReceivers(intent = new Intent(context, cls), 65536).size() > 0;
    }

    @Override
    public boolean isLocationAvailable(Context context) {
        if (!this.locationAssessed && this.config != null) {
            this.locationAvailable = this.config.getBooleanProperty("socialize.location.enabled", true) && (this.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION") || this.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION"));
            this.locationAssessed = true;
        }
        return this.locationAvailable;
    }

    @Override
    public boolean isNotificationsAvailable(Context context) {
        if (!this.notificationsAssessed) {
            String permissionString = context.getPackageName() + ".permission.C2D_MESSAGE";
            boolean ok = true;
            if (this.config.getBooleanProperty("socialize.notification.enabled", true)) {
                if (!this.hasPermission(context, permissionString)) {
                    this.lastNotificationWarning = "Notifications not available, permission [" + permissionString + "] not specified in AndroidManifest.xml";
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.lastNotificationWarning);
                    }
                    ok = false;
                }
                if (!this.hasPermission(context, "com.google.android.c2dm.permission.RECEIVE")) {
                    this.lastNotificationWarning = "Notifications not available, permission com.google.android.c2dm.permission.RECEIVE not specified in AndroidManifest.xml, or device does not include Google APIs";
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.lastNotificationWarning);
                    }
                    ok = false;
                }
                if (this.config.isEntityLoaderCheckEnabled() && this.getSocialize().getEntityLoader() == null) {
                    this.lastNotificationWarning = "Notifications not available. Entity loader not found.";
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.lastNotificationWarning);
                    }
                    ok = false;
                }
            } else {
                ok = false;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("SmartAlerts disabled in config");
                }
            }
            this.notificationsAvailable = ok;
            this.notificationsAssessed = true;
        } else if (!this.notificationsAvailable && this.lastNotificationWarning != null && this.logger.isInfoEnabled()) {
            this.logger.info(this.lastNotificationWarning);
        }
        return this.notificationsAvailable;
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    @Override
    public void checkAndroidManifest(Context context) {
        this.checkActivitiesExist(context, CommentActivity.class, ActionDetailActivity.class, ProfileActivity.class, FacebookActivity.class, SocializeLaunchActivity.class);
        ActivityInfo info = this.getActivityInfo(context, SocializeLaunchActivity.class);
        if (info != null) {
            if ((info.flags & 0x80) != 128) {
                this.logger.warn("Activity flag android:noHistory=\"true\" not found for " + SocializeLaunchActivity.class.getSimpleName() + ".  Please ensure this is added to the declaration of this activity in your AndroidManifest.xml");
            }
            if ((info.launchMode & 1) == 1) {
                this.logger.warn("Activity flag android:launchMode=\"singleTop\" found for " + SocializeLaunchActivity.class.getSimpleName() + ".  This should be removed from the declaration of this activity in your AndroidManifest.xml");
            }
        }
        if ((info = this.getActivityInfo(context, CommentActivity.class)) != null && (info.configChanges & 0x80) != 128) {
            this.logger.warn("Activity flag android:configChanges=\"orientation|keyboardHidden|screenSize\" not found for " + CommentActivity.class.getSimpleName() + ".  Please ensure this is added to the declaration of this activity in your AndroidManifest.xml");
        }
    }

    protected void checkActivitiesExist(Context context, Class<?> ... classes) {
        for (Class<?> cls : classes) {
            ActivityInfo info = this.getActivityInfo(context, cls);
            if (info != null) continue;
            this.logger.warn("No activity element declared for [" + cls.getName() + "].  Please ensure you have included this in your AndroidManifest.xml");
        }
    }

    @Override
    public boolean hasPermission(Context context, String permission) {
        return context.getPackageManager().checkPermission(permission, context.getPackageName()) == 0;
    }

    public static boolean launchMainApp(Activity origin) {
        Intent mainIntent = DefaultAppUtils.getMainAppIntent((Context)origin);
        if (mainIntent != null) {
            origin.startActivity(mainIntent);
            return true;
        }
        return false;
    }

    public static Intent getMainAppIntent(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent mainIntent = new Intent("android.intent.action.MAIN");
        mainIntent.addCategory("android.intent.category.LAUNCHER");
        mainIntent.setPackage(context.getPackageName());
        List appList = pm.queryIntentActivities(mainIntent, 0);
        if (appList != null && appList.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)appList.get(0);
            mainIntent.setFlags(0x4000000);
            mainIntent.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
            return mainIntent;
        }
        return null;
    }

    @Override
    public int getAppIconId(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return applicationInfo.icon;
    }

    @Override
    public String getUserAgentString() {
        if (this.userAgent == null) {
            this.userAgent = "Android-" + Build.VERSION.SDK_INT + "/" + Build.MODEL + " SocializeSDK/v" + "3.1.5" + "; " + Locale.getDefault().getLanguage() + "_" + this.getCountry() + "; BundleID/" + this.getPackageName() + "; Carrier/" + this.carrier + ";";
        }
        return this.userAgent + " Network/" + this.networkType + ";";
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getCarrier() {
        return this.carrier;
    }

    @Override
    public String getNetworkType() {
        return this.networkType;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    void setNotificationsAssessed(boolean notificationsAssessed) {
        this.notificationsAssessed = notificationsAssessed;
    }
}

