/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.view.AuthenticatedView;

public abstract class EntityView
extends AuthenticatedView {
    public EntityView(Context context) {
        super(context);
    }

    public EntityView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public View getView() {
        try {
            String[] bundleKeys;
            Context context = this.getViewContext();
            Bundle bundle = null;
            if (context instanceof Activity) {
                Activity a = (Activity)context;
                bundle = a.getIntent().getExtras();
            }
            if (bundle != null && (bundleKeys = this.getBundleKeys()) != null && bundleKeys.length > 0) {
                Object[] values = new Object[bundleKeys.length];
                for (int i = 0; i < bundleKeys.length; ++i) {
                    values[i] = bundle.get(bundleKeys[i]);
                }
                return this.getView(bundle, values);
            }
            return this.getView(bundle, null);
        }
        catch (Throwable e) {
            SocializeLogger.e("", e);
            return this.getErrorView();
        }
    }

    protected View getErrorView() {
        FrameLayout view = new FrameLayout(this.getContext());
        FrameLayout.LayoutParams loadingScreenLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        FrameLayout.LayoutParams progressLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        loadingScreenLayoutParams.gravity = 17;
        progressLayoutParams.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)loadingScreenLayoutParams);
        TextView errorView = new TextView(this.getContext());
        errorView.setText((CharSequence)"Unable to load view");
        view.addView((View)errorView);
        return view;
    }

    protected abstract View getView(Bundle var1, Object ... var2);

    protected abstract String[] getBundleKeys();
}

