/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.i18n.LocalizationService;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;

public abstract class ClickableSectionCell
extends LinearLayout {
    protected LocalizationService localizationService;
    protected Drawables drawables;
    protected Colors colors;
    protected DisplayUtils displayUtils;
    private String displayTextKey;
    private TextView textView;
    private ImageView imageView;
    private String backgroundColor;
    private String textColor;
    private OnToggleListener onToggleListener;
    private int bgColor;
    private int txtColor;
    private int strokeColor = -1;
    private int bgAlpha = 128;
    private Drawable imageOn;
    private Drawable imageOff;
    private String toggledDrawableName = null;
    private String untoggledDrawableName = null;
    private float topLeftRadius = 6.0f;
    private float topRightRadius = 6.0f;
    private float bottomLeftRadius = 6.0f;
    private float bottomRightRadius = 6.0f;
    private boolean canClick = true;
    private boolean toggled = true;
    private int topStroke = 1;
    private int rightStroke = 1;
    private int bottomStroke = 1;
    private int leftStroke = 1;
    private int strokeCornerOffset = 2;
    private float[] radii;
    private float[] strokeRadii;
    private GradientDrawable background;
    private GradientDrawable stroke;
    private LayerDrawable bgLayer;
    private ImageView arrowIcon;
    private int cellWidth = -1;

    public ClickableSectionCell(Context context) {
        super(context);
    }

    public void init() {
        if (this.strokeColor < 0 && this.colors != null) {
            this.strokeColor = this.colors.getColor("CLICKABLE_CELL_STROKE");
        }
        if (this.displayUtils != null) {
            this.topLeftRadius = this.displayUtils.getDIP(this.topLeftRadius);
            this.topRightRadius = this.displayUtils.getDIP(this.topRightRadius);
            this.bottomRightRadius = this.displayUtils.getDIP(this.bottomRightRadius);
            this.bottomLeftRadius = this.displayUtils.getDIP(this.bottomLeftRadius);
        }
        this.radii = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
        if (!StringUtils.isEmpty(this.backgroundColor)) {
            this.bgColor = Colors.parseColor(this.backgroundColor);
        } else if (this.colors != null) {
            this.bgColor = this.colors.getColor("ACTIVITY_BG");
        }
        if (!StringUtils.isEmpty(this.textColor)) {
            this.txtColor = Colors.parseColor(this.textColor);
        } else if (this.colors != null) {
            this.txtColor = this.colors.getColor("BODY");
        }
        if (this.cellWidth < 0) {
            this.cellWidth = -1;
        }
        LinearLayout master = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(this.cellWidth, -2);
        LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams iconParams = new LinearLayout.LayoutParams(-2, -2);
        textParams.weight = 1.0f;
        textParams.gravity = 19;
        iconParams.gravity = 21;
        int margin = 0;
        if (this.displayUtils != null) {
            margin = this.displayUtils.getDIP(4);
        }
        textParams.setMargins(margin * 2, 0, margin, 0);
        iconParams.setMargins(margin, 0, margin, 0);
        View text = this.makeDisplayText();
        text.setLayoutParams((ViewGroup.LayoutParams)textParams);
        this.imageView = this.makeImage();
        if (this.imageOn != null) {
            this.imageView.setImageDrawable(this.imageOn);
        }
        master.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        this.setBackground();
        if (this.imageView != null) {
            master.addView((View)this.imageView);
        }
        master.addView(text);
        if (this.canClick && this.toggledDrawableName != null) {
            this.arrowIcon = new ImageView(this.getContext());
            this.arrowIcon.setImageDrawable(this.drawables.getDrawable(this.toggledDrawableName));
            this.arrowIcon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
            master.addView((View)this.arrowIcon);
        }
        this.addView((View)master);
    }

    protected View makeDisplayText() {
        this.textView = new TextView(this.getContext());
        this.textView.setText((CharSequence)this.localizationService.getString(this.displayTextKey));
        this.textView.setTextColor(this.txtColor);
        this.textView.setTextSize(1, 16.0f);
        return this.textView;
    }

    protected abstract ImageView makeImage();

    protected void setBackground() {
        if (this.background == null) {
            this.background = this.makeGradient(this.bgColor, this.bgColor);
        }
        if (this.stroke == null) {
            this.stroke = this.makeGradient(this.strokeColor, this.strokeColor);
        }
        if (this.bgLayer == null) {
            this.bgLayer = new LayerDrawable(new Drawable[]{this.stroke, this.background});
        }
        this.strokeRadii = new float[8];
        this.initBackground();
    }

    protected void initBackground() {
        if (this.background != null) {
            this.background.setCornerRadii(this.radii);
            this.background.setAlpha(this.bgAlpha);
        }
        if (this.bgLayer != null) {
            this.bgLayer.setLayerInset(1, this.leftStroke, this.topStroke, this.rightStroke, this.bottomStroke);
        }
        if (this.stroke != null) {
            int pixel = this.displayUtils.getDIP(this.strokeCornerOffset);
            for (int i = 0; i < this.strokeRadii.length; ++i) {
                this.strokeRadii[i] = this.radii[i] > 0.0f ? this.radii[i] + (float)pixel : 0.0f;
            }
            this.stroke.setCornerRadii(this.strokeRadii);
            this.stroke.setAlpha(this.bgAlpha);
        }
        CompatUtils.setBackgroundDrawable((View)this, (Drawable)this.bgLayer);
        if (this.displayUtils != null) {
            int padding = this.displayUtils.getDIP(8);
            this.setPadding(padding, padding, padding, padding);
        }
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setDisplayUtils(DisplayUtils displayUtils) {
        this.displayUtils = displayUtils;
    }

    public void setDisplayTextKey(String displayTextKey) {
        this.displayTextKey = displayTextKey;
        if (this.textView != null) {
            this.textView.setText((CharSequence)this.localizationService.getString(displayTextKey));
        }
    }

    public void setImageOn(Drawable image) {
        this.imageOn = image;
    }

    public Drawable getImageOff() {
        return this.imageOff;
    }

    public void setImageOff(Drawable imageOff) {
        this.imageOff = imageOff;
    }

    public Drawable getImageOn() {
        return this.imageOn;
    }

    public void setBackgroundData(float[] radii, int[] strokes, int strokeColor) {
        this.strokeColor = strokeColor;
        this.topStroke = strokes[0];
        this.rightStroke = strokes[1];
        this.bottomStroke = strokes[2];
        this.leftStroke = strokes[3];
        this.radii = radii;
        this.initBackground();
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBgAlpha(int bgAlpha) {
        this.bgAlpha = bgAlpha;
    }

    public void setCanClick(boolean clickable) {
        this.canClick = clickable;
    }

    public void setStrokeCornerOffset(int strokeCornerOffset) {
        this.strokeCornerOffset = strokeCornerOffset;
    }

    public void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
    }

    public void setToggledDrawableName(String toggledDrawableName) {
        this.toggledDrawableName = toggledDrawableName;
    }

    public void setUntoggledDrawableName(String untoggledDrawableName) {
        this.untoggledDrawableName = untoggledDrawableName;
    }

    protected GradientDrawable makeGradient(int bottom, int top) {
        return new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{bottom, top});
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setOnToggleListener(OnToggleListener onToggleListener) {
        this.onToggleListener = onToggleListener;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
        if (toggled) {
            if (this.imageOn != null) {
                this.imageView.setImageDrawable(this.imageOn);
            }
            if (this.arrowIcon != null && this.toggledDrawableName != null) {
                this.arrowIcon.setImageDrawable(this.drawables.getDrawable(this.toggledDrawableName));
            }
        } else {
            if (this.imageOff != null) {
                this.imageView.setImageDrawable(this.imageOff);
            }
            if (this.arrowIcon != null && this.untoggledDrawableName != null) {
                this.arrowIcon.setImageDrawable(this.drawables.getDrawable(this.untoggledDrawableName));
            }
        }
        if (this.onToggleListener != null) {
            this.onToggleListener.onToggle(toggled);
        }
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public static interface OnToggleListener {
        public void onToggle(boolean var1);
    }
}

