/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.image.ImageLoadListener;
import com.socialize.ui.image.ImageLoadRequest;
import com.socialize.ui.view.CachedImageViewChangeListener;
import com.socialize.util.Drawables;
import com.socialize.util.SafeBitmapDrawable;

public class CachedImageView
extends View
implements ImageLoadListener {
    private Drawables drawables;
    private String imageName;
    private String expectedImageName;
    private int changes = 0;
    private boolean local = true;
    private Drawable drawable;
    private SocializeLogger logger;
    private CachedImageViewChangeListener changeListener;
    private int width;
    private int height;
    private int x;
    private int y;
    private final int REDRAW = 101;
    private final int CHANGE = 102;
    private Handler mRedrawHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 101: {
                    CachedImageView.this.invalidate();
                    if (CachedImageView.this.changeListener == null) break;
                    CachedImageView.this.changeListener.onRedraw(CachedImageView.this);
                    break;
                }
                case 102: {
                    Bundle data = msg.getData();
                    CachedImageView.this.setImageUrlImmediate(data.getString("imageName"), data.getBoolean("local"));
                    if (CachedImageView.this.changeListener == null) break;
                    CachedImageView.this.changeListener.onChange(CachedImageView.this);
                }
            }
        }
    };

    public CachedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public CachedImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CachedImageView(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int rawWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - (this.getPaddingLeft() + this.getPaddingRight());
        int rawHeight = View.MeasureSpec.getSize((int)heightMeasureSpec) - (this.getPaddingTop() + this.getPaddingBottom());
        this.setMeasuredDimension(rawWidth, rawHeight);
        this.width = rawWidth - this.getPaddingLeft() - this.getPaddingRight();
        this.height = rawHeight - this.getPaddingTop() - this.getPaddingBottom();
        this.x = rawWidth - this.width;
        this.y = rawHeight - this.height;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.drawable == null || this.changes > 0) {
            --this.changes;
            if (this.imageName != null) {
                this.drawable = this.local ? this.drawables.getDrawable(this.imageName) : (Drawable)this.drawables.getCache().get(this.imageName);
                if (this.drawable == null && this.logger != null) {
                    this.logger.error("No drawable found with name [" + this.imageName + "]");
                }
            }
        }
        if (this.drawable != null) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Image view is drawing " + this.imageName);
            }
            this.drawable.setBounds(this.x, this.y, this.width, this.height);
            this.drawable.draw(canvas);
        }
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setDefaultImage() {
        this.setImageUrlImmediate("default_user_icon.png", true);
    }

    public void setImageUrlImmediate(String url, boolean local) {
        this.imageName = url;
        this.local = local;
        ++this.changes;
        this.invalidate();
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Setting image to drawable name [" + url + "], draw should follow");
        }
    }

    void setImageName(String imageName, boolean local) {
        if (this.expectedImageName == null || this.expectedImageName.equals(imageName)) {
            Message m = Message.obtain();
            Bundle data = new Bundle();
            data.putString("imageName", imageName);
            data.putBoolean("local", local);
            m.setData(data);
            m.what = 102;
            this.mRedrawHandler.sendMessage(m);
        } else if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Image view was not updated.  Expected image name [" + this.expectedImageName + "] does not match requested image name [" + imageName + "]");
        }
    }

    @Override
    public synchronized void onImageLoad(ImageLoadRequest request, SafeBitmapDrawable drawable2) {
        this.setImageName(request.getUrl(), false);
    }

    @Override
    public synchronized void onImageLoadFail(ImageLoadRequest request, Exception error) {
        this.setDefaultImage();
    }

    public synchronized void setImageUrl(String imageUrl) {
        this.setImageName(imageUrl, false);
    }

    public void redraw() {
        this.mRedrawHandler.sendEmptyMessage(101);
    }

    public void notifyImageChange() {
        ++this.changes;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public CachedImageViewChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(CachedImageViewChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setExpectedImageName(String expectedImageName) {
        this.expectedImageName = expectedImageName;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Set expected image name to [" + expectedImageName + "]");
        }
    }
}

