/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.util;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import com.socialize.log.SocializeLogger;
import com.socialize.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class GeoUtils {
    private Geocoder geocoder;
    private SocializeLogger logger;

    public void init(Context context) {
        this.geocoder = new Geocoder(context, Locale.getDefault());
    }

    public Address geoCode(double lat, double lng) {
        try {
            List fromLocation = this.geocoder.getFromLocation(lat, lng, 1);
            if (fromLocation != null && fromLocation.size() > 0) {
                return (Address)fromLocation.get(0);
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.error("Error geocoding location [" + lat + "," + lng + "]", (Throwable)e);
            }
            SocializeLogger.e(e.getMessage(), e);
        }
        return null;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public String getSimpleLocation(Address address) {
        StringBuilder builder = new StringBuilder();
        String locality = address.getLocality();
        String countryName = address.getCountryName();
        if (!StringUtils.isEmpty(locality)) {
            builder.append(locality);
        } else if (!StringUtils.isEmpty(countryName)) {
            builder.append(countryName);
        }
        return builder.toString();
    }
}

