/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.util;

import com.socialize.i18n.LocalizationService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    public static final long minute = 60L;
    public static final long hour = 3600L;
    public static final long day = 86400L;
    public static final long month = 2592000L;
    public static final long year = 31536000L;
    private LocalizationService localizationService;
    private final DateFormat SIMPLE_DATE = new SimpleDateFormat("h:mm a 'on' dd MMM yyyy");

    public String getTimeString(long diffMilliseconds) {
        StringBuilder builder = new StringBuilder();
        long diff = diffMilliseconds / 1000L;
        String unit = null;
        long value = 0L;
        if (diff >= 60L && diff < 31536000L) {
            unit = diff > 3600L ? (diff > 86400L ? (diff > 2592000L ? ((value = diff / 2592000L) > 1L ? this.localizationService.getString("socialize_date_month_plural") : this.localizationService.getString("socialize_date_month")) : ((value = diff / 86400L) > 1L ? this.localizationService.getString("socialize_date_day_plural") : this.localizationService.getString("socialize_date_day"))) : ((value = diff / 3600L) > 1L ? this.localizationService.getString("socialize_date_hour_plural") : this.localizationService.getString("socialize_date_hour"))) : ((value = diff / 60L) > 1L ? this.localizationService.getString("socialize_date_minute_plural") : this.localizationService.getString("socialize_date_minute"));
            builder.append(value);
            builder.append(" ");
            builder.append(unit);
        } else if (diff < 60L) {
            builder.append(this.localizationService.getString("socialize_date_justnow"));
        } else {
            builder.append(this.localizationService.getString("socialize_year_ago"));
        }
        return builder.toString();
    }

    public synchronized String getSimpleDateString(Date date) {
        return this.SIMPLE_DATE.format(date);
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }
}

