/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.slider;

import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import com.socialize.ui.slider.ActionBarSliderItem;
import com.socialize.ui.slider.ActionBarSliderView;
import com.socialize.util.DisplayUtils;

public class SliderAnimationSet {
    private DisplayUtils displayUtils;
    private TranslateAnimation maximizeFromClose;
    private TranslateAnimation maximizeFromPeek;
    private TranslateAnimation peekFromClose;
    private TranslateAnimation peekFromMaximize;
    private TranslateAnimation closeFromPeek;
    private TranslateAnimation closeFromMaximized;

    public TranslateAnimation getMaximizeFromClose() {
        return this.maximizeFromClose;
    }

    public void setMaximizeFromClose(TranslateAnimation maximizeFromClose) {
        this.maximizeFromClose = maximizeFromClose;
    }

    public TranslateAnimation getMaximizeFromPeek() {
        return this.maximizeFromPeek;
    }

    public void setMaximizeFromPeek(TranslateAnimation maximizeFromPeek) {
        this.maximizeFromPeek = maximizeFromPeek;
    }

    public TranslateAnimation getPeekFromClose() {
        return this.peekFromClose;
    }

    public void setPeekFromClose(TranslateAnimation peekFromClose) {
        this.peekFromClose = peekFromClose;
    }

    public TranslateAnimation getPeekFromMaximize() {
        return this.peekFromMaximize;
    }

    public void setPeekFromMaximize(TranslateAnimation peekFromMaximize) {
        this.peekFromMaximize = peekFromMaximize;
    }

    public TranslateAnimation getCloseFromPeek() {
        return this.closeFromPeek;
    }

    public void setCloseFromPeek(TranslateAnimation closeFromPeek) {
        this.closeFromPeek = closeFromPeek;
    }

    public TranslateAnimation getCloseFromMaximized() {
        return this.closeFromMaximized;
    }

    public void setCloseFromMaximized(TranslateAnimation closeFromMaximized) {
        this.closeFromMaximized = closeFromMaximized;
    }

    protected void notifyMove(int height, ActionBarSliderView slider) {
        int yOffset = 0;
        switch (slider.getDisplayState()) {
            case CLOSE: {
                yOffset = slider.getActionBarTop();
                break;
            }
            case PEEK: {
                yOffset = slider.getActionBarTop() - slider.getHandleHeight();
                break;
            }
            case MAXIMIZE: {
                yOffset = slider.getDeviceHeight() - height;
            }
        }
        slider.getHandle().notifyMove(yOffset);
        slider.getContent().notifyMove(yOffset);
    }

    public void init(ActionBarSliderItem item, final ActionBarSliderView slider) {
        int slideHeight = item.getSliderContentHeight();
        int h = slider.getDeviceHeight();
        if (slideHeight > 0) {
            h = this.displayUtils.getDIP(slideHeight) + (slider.getDeviceHeight() - slider.getActionBarTop()) + slider.getHandleHeight();
        }
        final int height = h;
        Animation.AnimationListener visibleAnimation = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                slider.setVisibility(0);
                SliderAnimationSet.this.notifyMove(height, slider);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                slider.setMoving(false);
                slider.onOpen();
            }
        };
        Animation.AnimationListener hideAnimation = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SliderAnimationSet.this.notifyMove(height, slider);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                slider.setVisibility(8);
                slider.setMoving(false);
                slider.clearAnimation();
                slider.onClose();
            }
        };
        float closed = slider.getActionBarTop();
        float maximized = slider.getDeviceHeight() - height;
        float peeked = slider.getActionBarTop() - slider.getHandleHeight();
        this.maximizeFromClose = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, closed, 0, maximized);
        this.maximizeFromPeek = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, peeked, 0, maximized);
        this.peekFromClose = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, closed, 0, peeked);
        this.peekFromMaximize = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, maximized, 0, peeked);
        this.closeFromPeek = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, peeked, 0, closed);
        this.closeFromMaximized = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, maximized, 0, closed);
        this.setDefaultAnimationConfig((Animation)this.maximizeFromClose, visibleAnimation, 500L);
        this.setDefaultAnimationConfig((Animation)this.maximizeFromPeek, visibleAnimation, 500L);
        this.setDefaultAnimationConfig((Animation)this.peekFromClose, visibleAnimation, 700L);
        this.setDefaultAnimationConfig((Animation)this.peekFromMaximize, visibleAnimation, 500L);
        this.setDefaultAnimationConfig((Animation)this.closeFromPeek, hideAnimation, 700L);
        this.setDefaultAnimationConfig((Animation)this.closeFromMaximized, hideAnimation, 500L);
    }

    protected void setDefaultAnimationConfig(Animation anim, Animation.AnimationListener listener, long duration) {
        anim.setAnimationListener(listener);
        anim.setFillAfter(true);
        anim.setDuration(duration);
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }
}

